/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.parametermanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.commons.activation.ActivableObject;
import step.commons.activation.Activator;
import step.core.accessors.CRUDAccessor;
import step.core.objectenricher.ObjectFilter;
import step.plugins.parametermanager.Parameter;

public class ParameterManager {
    private static Logger logger = LoggerFactory.getLogger(ParameterManager.class);
    private CRUDAccessor<Parameter> parameterAccessor;

    public ParameterManager(CRUDAccessor<Parameter> parameterAccessor) {
        this.parameterAccessor = parameterAccessor;
    }

    public Map<String, String> getAllParameterValues(Map<String, Object> contextBindings, ObjectFilter objectFilter) {
        return this.getAllParameters(contextBindings, objectFilter).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Parameter)((Object)((Object)e.getValue()))).value));
    }

    public Map<String, Parameter> getAllParameters(Map<String, Object> contextBindings, ObjectFilter objectFilter) {
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        SimpleBindings bindings = contextBindings != null ? new SimpleBindings(contextBindings) : null;
        HashMap parameterMap = new HashMap();
        this.parameterAccessor.getAll().forEachRemaining(p -> {
            if (objectFilter == null || objectFilter.test((Object)p)) {
                ArrayList<Parameter> parameters = (ArrayList<Parameter>)parameterMap.get(p.key);
                if (parameters == null) {
                    parameters = new ArrayList<Parameter>();
                    parameterMap.put(p.key, parameters);
                }
                parameters.add((Parameter)((Object)p));
                try {
                    Activator.compileActivationExpression((ActivableObject)p);
                }
                catch (ScriptException e) {
                    logger.error("Error while compilating activation expression of parameter " + (Object)p, (Throwable)e);
                }
            }
        });
        for (String key : parameterMap.keySet()) {
            List parameters = (List)parameterMap.get(key);
            Parameter bestMatch = (Parameter)Activator.findBestMatch((Map)bindings, (List)parameters);
            if (bestMatch == null) continue;
            result.put(key, bestMatch);
        }
        return result;
    }
}

