/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.functions.types;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import javax.json.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.accessors.AbstractCRUDAccessor;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.plugins.AbstractControllerPlugin;
import step.core.plugins.Plugin;
import step.functions.Function;
import step.functions.accessor.FunctionAccessor;
import step.functions.base.types.LocalFunction;
import step.functions.base.types.LocalFunctionType;
import step.functions.base.types.handler.BaseFunctionReflectionHelper;
import step.functions.plugin.GridPlugin;
import step.functions.type.AbstractFunctionType;
import step.functions.type.FunctionTypeRegistry;
import step.handlers.javahandler.Keyword;

@Plugin(dependencies={GridPlugin.class})
public class BaseFunctionTypesPlugin
extends AbstractControllerPlugin {
    private static final Logger logger = LoggerFactory.getLogger(BaseFunctionTypesPlugin.class);

    public void executionControllerStart(GlobalContext context) throws Exception {
        super.executionControllerStart(context);
        FunctionTypeRegistry functionTypeRegistry = (FunctionTypeRegistry)context.get(FunctionTypeRegistry.class);
        functionTypeRegistry.registerFunctionType((AbstractFunctionType)new LocalFunctionType());
        this.setupLocalFunctionsIfNotExisting(context);
    }

    protected void setupLocalFunctionsIfNotExisting(GlobalContext context) {
        AbstractCRUDAccessor functionAccessor = (AbstractCRUDAccessor)context.get(FunctionAccessor.class);
        List keywordList = null;
        try {
            keywordList = BaseFunctionReflectionHelper.getLocalKeywordList(Keyword.class);
        }
        catch (Exception e) {
            logger.error("Error while getting local keyword list", (Throwable)e);
        }
        if (keywordList != null) {
            for (String keyword : keywordList) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("name", keyword);
                Function function = (Function)functionAccessor.findByAttributes(attributes);
                if (function != null) continue;
                function = new LocalFunction();
                function.setAttributes(attributes);
                try {
                    function.setSchema(Json.createReader((Reader)new StringReader((String)BaseFunctionReflectionHelper.getLocalKeywordsWithSchemas().get(keyword))).readObject());
                }
                catch (Exception e) {
                    function.setSchema(Json.createReader((Reader)new StringReader("{}")).readObject());
                }
                functionAccessor.save((AbstractIdentifiableObject)function);
            }
        }
    }
}

