/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.datatable.formatters;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import org.bson.BSONException;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;
import org.bson.json.StrictCharacterStreamJsonWriter;
import org.bson.types.ObjectId;

public class DocumentToJsonFormatter {
    public String format(Document row) {
        CustomJsonWriter writer = new CustomJsonWriter(new StringWriter(), new JsonWriterSettings());
        new DocumentCodec().encode((BsonWriter)writer, row, EncoderContext.builder().isEncodingCollectibleDocument(true).build());
        String json = writer.getWriter().toString();
        return json;
    }

    public static class CustomJsonWriter
    extends JsonWriter {
        private Writer writer;

        public CustomJsonWriter(Writer writer) {
            super(writer);
            this.writer = writer;
        }

        public CustomJsonWriter(Writer writer, JsonWriterSettings settings) {
            super(writer, settings);
            this.writer = writer;
        }

        public void doWriteObjectId(ObjectId objectId) {
            this.writeString(objectId.toString());
        }

        public void writeName(String name) {
            if ("_id".equals(name)) {
                super.writeName("id");
            } else {
                super.writeName(name);
            }
        }

        protected void doWriteInt64(long value) {
            try {
                Field f = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("strictJsonWriter");
                f.setAccessible(true);
                StrictCharacterStreamJsonWriter writer = (StrictCharacterStreamJsonWriter)f.get((Object)this);
                writer.writeNumber(Long.toString(value));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new BSONException("Wrapping IOException", (Throwable)e);
            }
        }
    }
}

