/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.datatable;

import java.util.ArrayList;
import java.util.List;
import step.core.accessors.Collection;
import step.plugins.datatable.CollectionQueryFactory;
import step.plugins.datatable.ColumnDef;
import step.plugins.datatable.DateRangeCriterium;
import step.plugins.datatable.MultiTextCriterium;
import step.plugins.datatable.PrefixedTextCriterium;
import step.plugins.datatable.TextCriterium;
import step.plugins.datatable.formatters.ArrayFormatter;
import step.plugins.datatable.formatters.DateFormatter;
import step.plugins.datatable.formatters.Formatter;
import step.plugins.datatable.formatters.JsonFormatter;
import step.plugins.datatable.formatters.RowAsJsonFormatter;
import step.plugins.datatable.formatters.StringFormatter;
import step.plugins.screentemplating.InputType;

public class BackendDataTable {
    private Collection collection;
    private List<ColumnDef> columns = new ArrayList<ColumnDef>();
    private List<ColumnDef> exportColumns;
    private CollectionQueryFactory query;

    public BackendDataTable(Collection collection) {
        this.collection = collection;
    }

    public BackendDataTable setColumns(List<ColumnDef> columns) {
        this.columns = columns;
        return this;
    }

    public BackendDataTable setExportColumns(List<ColumnDef> columns) {
        this.exportColumns = columns;
        return this;
    }

    public boolean isFiltered() {
        return this.collection.isFiltered();
    }

    public List<ColumnDef> getExportColumns() {
        return this.exportColumns;
    }

    public BackendDataTable addColumn(String columnTitle, String value) {
        this.columns.add(new ColumnDef(columnTitle, value, InputType.TEXT, new StringFormatter(), new TextCriterium(), null));
        return this;
    }

    public BackendDataTable addJsonColumn(String columnTitle, String value) {
        this.columns.add(new ColumnDef(columnTitle, value, InputType.NONE, new JsonFormatter(), null, null));
        return this;
    }

    public BackendDataTable addArrayColumn(String columnTitle, String value) {
        this.columns.add(new ColumnDef(columnTitle, value, InputType.NONE, new ArrayFormatter(), null, null));
        return this;
    }

    public BackendDataTable addTextWithDropdownColumn(String columnTitle, String value) {
        List distinct = this.collection.distinct(value);
        return this.addTextWithDropdownColumn(columnTitle, value, distinct);
    }

    public BackendDataTable addTextWithDropdownColumn(String columnTitle, String value, List<String> options) {
        this.columns.add(new ColumnDef(columnTitle, value, InputType.TEXT_DROPDOWN, new StringFormatter(), new TextCriterium(), options));
        return this;
    }

    public BackendDataTable addTextWithDropdownColumnOptimized(String columnTitle, String value, List<String> options) {
        this.columns.add(new ColumnDef(columnTitle, value, InputType.TEXT_DROPDOWN, new StringFormatter(), new PrefixedTextCriterium(), options));
        return this;
    }

    public BackendDataTable addDateColumn(String columnTitle, String value) {
        this.columns.add(new ColumnDef(columnTitle, value, InputType.DATE_RANGE, new DateFormatter("dd.MM.yyyy HH:mm:ss"), new DateRangeCriterium("dd.MM.yyyy"), null));
        return this;
    }

    public BackendDataTable addDateAsEpochColumn(String columnTitle, String value) {
        this.columns.add(new ColumnDef(columnTitle, value, InputType.DATE_RANGE, new StringFormatter(), new DateRangeCriterium("dd.MM.yyyy"), null));
        return this;
    }

    public BackendDataTable addTimeColumn(String columnTitle, String value) {
        this.columns.add(new ColumnDef(columnTitle, value, InputType.TEXT, new DateFormatter("HH:mm:ss"), new DateRangeCriterium("dd.MM.yyyy"), null));
        return this;
    }

    public BackendDataTable addRowAsJson(String columnTitle) {
        this.columns.add(new ColumnDef(columnTitle, null, InputType.NONE, new RowAsJsonFormatter(), null, null));
        return this;
    }

    public BackendDataTable addRowAsJson(String columnTitle, List<String> searchAttributes) {
        this.columns.add(new ColumnDef(columnTitle, null, InputType.TEXT, new RowAsJsonFormatter(), new MultiTextCriterium(searchAttributes), null));
        return this;
    }

    public BackendDataTable addCustomColumn(String columnTitle, Formatter formatter) {
        this.columns.add(new ColumnDef(columnTitle, null, InputType.NONE, formatter, null, null));
        return this;
    }

    public ColumnDef getColumnByID(int i) {
        return this.columns.get(i);
    }

    public Collection getCollection() {
        return this.collection;
    }

    public List<ColumnDef> getColumns() {
        return this.columns;
    }

    public CollectionQueryFactory getQuery() {
        return this.query;
    }

    public BackendDataTable setQuery(CollectionQueryFactory query) {
        this.query = query;
        return this;
    }
}

