/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.screentemplating;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import step.commons.activation.Activator;
import step.plugins.screentemplating.Input;
import step.plugins.screentemplating.Option;
import step.plugins.screentemplating.ScreenInputAccessor;
import step.plugins.screentemplating.ScreenTemplateChangeListener;

public class ScreenTemplateManager {
    protected final List<ScreenTemplateChangeListener> listeners = new ArrayList<ScreenTemplateChangeListener>();
    protected ScreenInputAccessor screenInputAccessor;

    public ScreenTemplateManager(ScreenInputAccessor screenInputAccessor) {
        this.screenInputAccessor = screenInputAccessor;
    }

    public List<Input> getInputsForScreen(String screenId, Map<String, Object> contextBindings) {
        List screenInputs = this.screenInputAccessor.getScreenInputsByScreenId(screenId).stream().map(i -> i.getInput()).collect(Collectors.toList());
        ArrayList<Input> result = new ArrayList<Input>();
        List inputs = Activator.findAllMatches(contextBindings, screenInputs);
        for (Input input : inputs) {
            List<Option> options = input.getOptions();
            List activeOptions = null;
            if (options != null) {
                activeOptions = Activator.findAllMatches(contextBindings, options);
            }
            result.add(new Input(input.getType(), input.getId(), input.getLabel(), activeOptions));
        }
        return result;
    }

    public void registerListener(ScreenTemplateChangeListener listener) {
        this.listeners.add(listener);
    }

    public void notifyChange() {
        this.listeners.forEach(l -> l.onChange());
    }
}

