/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.quotamanager;

import ch.exense.commons.io.FileWatchService;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.common.managedoperations.OperationManager;
import step.core.GlobalContext;
import step.core.artefacts.reports.ReportNode;
import step.core.execution.ExecutionContext;
import step.core.plugins.AbstractControllerPlugin;
import step.core.plugins.Plugin;
import step.plugins.quotamanager.QuotaManager;
import step.plugins.quotamanager.QuotaManagerServices;

@Plugin
public class QuotaManagerPlugin
extends AbstractControllerPlugin {
    private ConcurrentHashMap<String, UUID> permits = new ConcurrentHashMap();
    private FileWatchService fileWatchService;
    private OperationManager operationManager = OperationManager.getInstance();
    private QuotaManager quotaManager;
    private boolean enabled = false;
    private static final Logger logger = LoggerFactory.getLogger(QuotaManagerPlugin.class);

    public void beforeReportNodeExecution(ExecutionContext context, ReportNode node) {
        if (this.enabled) {
            UUID permit;
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            bindings.putAll(context.getVariablesManager().getAllVariables());
            bindings.put("node", node);
            this.operationManager.enter("Waiting for quota", new Object());
            try {
                permit = this.quotaManager.acquirePermit(bindings);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while getting permit from quota manager", e);
            }
            finally {
                this.operationManager.exit();
            }
            this.permits.put(node.getId().toString(), permit);
        }
    }

    public void afterReportNodeExecution(ReportNode node) {
        UUID permit;
        if (this.enabled && (permit = this.permits.remove(node.getId().toString())) != null) {
            this.quotaManager.releasePermit(permit);
        }
    }

    private QuotaManager initQuotaManager(String config) {
        final File configFile = new File(config);
        this.quotaManager = new QuotaManager(configFile);
        this.fileWatchService = new FileWatchService();
        this.fileWatchService.register(configFile, new Runnable(){

            @Override
            public void run() {
                QuotaManagerPlugin.this.quotaManager.loadConfiguration(configFile);
            }
        });
        return this.quotaManager;
    }

    public void executionControllerStart(GlobalContext context) {
        context.getServiceRegistrationCallback().registerService(QuotaManagerServices.class);
        String config = context.getConfiguration().getProperty("quotamanager.config");
        if (config != null) {
            QuotaManager manager = this.initQuotaManager(config);
            context.put(QuotaManager.class, (Object)manager);
            this.enabled = true;
        }
    }

    public void executionControllerDestroy(GlobalContext context) {
        if (this.fileWatchService != null) {
            try {
                this.fileWatchService.close();
            }
            catch (IOException e) {
                logger.error("Error while closing file watch service", (Throwable)e);
            }
        }
        super.executionControllerDestroy(context);
    }
}

