/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.parametermanager;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import org.bson.types.ObjectId;
import step.commons.activation.Expression;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.CRUDAccessor;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.plugins.parametermanager.Parameter;
import step.plugins.parametermanager.ParameterScope;

@Path(value="/parameters")
public class ParameterServices
extends AbstractServices {
    CRUDAccessor<Parameter> parameterAccessor;
    public static final String PROTECTED_VALUE = "******";

    @PostConstruct
    public void init() throws Exception {
        super.init();
        this.parameterAccessor = (CRUDAccessor)this.getContext().get((Object)"ParameterAccessor");
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="param-write")
    public Parameter newParameter(@Context ContainerRequestContext crc) {
        Parameter parameter = new Parameter(new Expression(""), "", "", "");
        parameter.setPriority(1);
        if (this.hasGlobalParamRight(crc)) {
            parameter.setScope(ParameterScope.GLOBAL);
        } else {
            parameter.setScope(ParameterScope.FUNCTION);
        }
        return parameter;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="param-write")
    public Parameter save(Parameter newParameter, @Context ContainerRequestContext crc) {
        this.assertRights(newParameter, crc);
        Parameter oldParameter = newParameter.getId() != null ? (Parameter)this.parameterAccessor.get(newParameter.getId()) : null;
        if (oldParameter == null) {
            newParameter.setProtectedValue(ParameterServices.isPassword(newParameter));
        } else {
            if (newParameter.getValue().equals(PROTECTED_VALUE)) {
                newParameter.setValue(oldParameter.getValue());
            }
            if (this.isProtected(oldParameter)) {
                newParameter.setProtectedValue(true);
            } else {
                newParameter.setProtectedValue(ParameterServices.isPassword(newParameter));
            }
        }
        String lastModificationUser = this.getSession(crc).getUsername();
        Date lastModificationDate = new Date();
        newParameter.setLastModificationDate(lastModificationDate);
        newParameter.setLastModificationUser(lastModificationUser);
        return (Parameter)this.parameterAccessor.save((AbstractIdentifiableObject)newParameter);
    }

    protected void assertRights(Parameter newParameter, ContainerRequestContext crc) {
        if (!(newParameter.getScope() != null && newParameter.getScope() != ParameterScope.GLOBAL || this.hasGlobalParamRight(crc))) {
            throw new RuntimeException("The user is missing the right 'param-global-write' to write global parameters.");
        }
    }

    protected boolean hasGlobalParamRight(ContainerRequestContext crc) {
        return this.getSession(crc).getProfile().getRights().contains("param-global-write");
    }

    protected boolean isProtected(Parameter oldParameter) {
        return oldParameter.getProtectedValue() != null && oldParameter.getProtectedValue() != false;
    }

    @POST
    @Path(value="/{id}/copy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="param-write")
    public Parameter copy(@PathParam(value="id") String id, @Context ContainerRequestContext crc) {
        Parameter parameter = (Parameter)this.parameterAccessor.get(new ObjectId(id));
        parameter.setId(new ObjectId());
        return this.save(parameter, crc);
    }

    @DELETE
    @Path(value="/{id}")
    @Secured(right="param-delete")
    public void delete(@PathParam(value="id") String id, @Context ContainerRequestContext crc) {
        Parameter parameter = (Parameter)this.parameterAccessor.get(new ObjectId(id));
        this.assertRights(parameter, crc);
        this.parameterAccessor.remove(new ObjectId(id));
    }

    public static boolean isPassword(Parameter parameter) {
        return parameter != null && ParameterServices.isPassword(parameter.getKey());
    }

    public static boolean isPassword(String key) {
        return key != null && (key.contains("pwd") || key.contains("password"));
    }

    @GET
    @Path(value="/{id}")
    @Secured(right="param-read")
    public Parameter get(@PathParam(value="id") String id) {
        Parameter parameter = (Parameter)this.parameterAccessor.get(new ObjectId(id));
        if (parameter != null) {
            this.maskProtectedValue(parameter);
        }
        return parameter;
    }

    protected Parameter maskProtectedValue(Parameter parameter) {
        if (this.isProtected(parameter)) {
            parameter.setValue(PROTECTED_VALUE);
        }
        return parameter;
    }

    @GET
    @Path(value="/all")
    @Secured(right="param-read")
    public List<Parameter> getAll() {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        this.parameterAccessor.getAll().forEachRemaining(p -> result.add(this.maskProtectedValue((Parameter)((Object)p))));
        return result;
    }
}

