/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.parametermanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.accessors.AbstractCRUDAccessor;
import step.core.accessors.CRUDAccessor;
import step.core.accessors.Collection;
import step.core.accessors.CollectionRegistry;
import step.core.artefacts.reports.ReportNode;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionContextBindings;
import step.core.execution.ExecutionManager;
import step.core.execution.model.ExecutionParameters;
import step.core.plugins.AbstractControllerPlugin;
import step.core.plugins.Plugin;
import step.core.variables.VariableType;
import step.core.variables.VariablesManager;
import step.functions.Function;
import step.plugins.parametermanager.Parameter;
import step.plugins.parametermanager.ParameterCollection;
import step.plugins.parametermanager.ParameterManager;
import step.plugins.parametermanager.ParameterScope;
import step.plugins.parametermanager.ParameterServices;

@Plugin
public class ParameterManagerPlugin
extends AbstractControllerPlugin {
    private static final String PARAMETER_SCOPE_VALUE_DEFAULT = "default";
    private static final String PARAMETERS_BY_SCOPE = "$parametersByScope";
    public static Logger logger = LoggerFactory.getLogger(ParameterManagerPlugin.class);
    protected ParameterManager parameterManager;

    public void executionControllerStart(GlobalContext context) {
        AbstractCRUDAccessor parameterAccessor = new AbstractCRUDAccessor(context.getMongoClientSession(), "parameters", Parameter.class);
        context.put("ParameterAccessor", (Object)parameterAccessor);
        ((CollectionRegistry)context.get(CollectionRegistry.class)).register("parameters", (Collection)new ParameterCollection(context.getMongoClientSession().getMongoDatabase()));
        ParameterManager parameterManager = new ParameterManager((CRUDAccessor<Parameter>)parameterAccessor);
        context.put(ParameterManager.class, (Object)parameterManager);
        this.parameterManager = parameterManager;
        context.getServiceRegistrationCallback().registerService(ParameterServices.class);
    }

    public void executionStart(ExecutionContext context) {
        if (this.parameterManager != null) {
            ReportNode rootNode = context.getReport();
            HashMap<String, String> globalParametersFromExecutionParameters = new HashMap<String, String>();
            ExecutionParameters executionParameters = context.getExecutionParameters();
            if (executionParameters.getUserID() != null) {
                globalParametersFromExecutionParameters.put("user", executionParameters.getUserID());
            }
            if (executionParameters.getCustomParameters() != null) {
                globalParametersFromExecutionParameters.putAll(executionParameters.getCustomParameters());
            }
            ParameterManagerPlugin.putVariables(context, rootNode, globalParametersFromExecutionParameters, VariableType.IMMUTABLE);
            Map contextBindings = ExecutionContextBindings.get((ExecutionContext)context);
            Map<String, Parameter> allParameters = this.parameterManager.getAllParameters(contextBindings);
            this.buildExecutionParametersMapAndUpdateExecution(context, globalParametersFromExecutionParameters, allParameters);
            Map<ParameterScope, Map<String, List<Parameter>>> parametersByScope = this.getAllParametersByScope(allParameters);
            context.put(PARAMETERS_BY_SCOPE, parametersByScope);
            this.addScopeParametersToContext(context, rootNode, parametersByScope, ParameterScope.GLOBAL, PARAMETER_SCOPE_VALUE_DEFAULT);
        } else {
            logger.warn("Not able to read parameters. ParameterManager has not been initialized during controller start.");
        }
        super.executionStart(context);
    }

    public void beforeFunctionExecution(ExecutionContext context, ReportNode node, Function function) {
        super.beforeFunctionExecution(context, node, function);
        Map parametersByScope = (Map)context.get((Object)PARAMETERS_BY_SCOPE);
        this.addScopeParametersToContext(context, node, parametersByScope, ParameterScope.FUNCTION, (String)function.getAttributes().get("name"));
        this.addScopeParametersToContext(context, node, parametersByScope, ParameterScope.APPLICATION, (String)function.getAttributes().get("app"));
    }

    protected void buildExecutionParametersMapAndUpdateExecution(ExecutionContext context, Map<String, String> additionalGlobalParameters, Map<String, Parameter> allParameters) {
        ExecutionManager executionManager = (ExecutionManager)context.get(ExecutionManager.class);
        if (executionManager != null) {
            HashMap<String, String> executionParameters = new HashMap<String, String>();
            executionParameters.putAll(additionalGlobalParameters);
            executionParameters.putAll(allParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Parameter)((Object)((Object)e.getValue()))).getValue())));
            executionManager.updateParameters(context, executionParameters);
        }
    }

    protected Map<ParameterScope, Map<String, List<Parameter>>> getAllParametersByScope(Map<String, Parameter> allParameters) {
        HashMap<ParameterScope, Map<String, List<Parameter>>> parametersByScope = new HashMap<ParameterScope, Map<String, List<Parameter>>>();
        allParameters.forEach((k, v) -> {
            ParameterScope scope = v.scope != null ? v.scope : ParameterScope.GLOBAL;
            String scopeValue = v.scopeEntity != null ? v.scopeEntity : PARAMETER_SCOPE_VALUE_DEFAULT;
            parametersByScope.computeIfAbsent(scope, t -> new HashMap()).computeIfAbsent(scopeValue, t -> new ArrayList()).add(v);
        });
        return parametersByScope;
    }

    protected void addScopeParametersToContext(ExecutionContext context, ReportNode node, Map<ParameterScope, Map<String, List<Parameter>>> parametersByScope, ParameterScope scope, String scopeValue) {
        List<Parameter> scopeValueSpecificParameters;
        VariablesManager varMan = context.getVariablesManager();
        Map<String, List<Parameter>> scopeSpecificParameters = parametersByScope.get((Object)scope);
        if (scopeSpecificParameters != null && (scopeValueSpecificParameters = scopeSpecificParameters.get(scopeValue)) != null) {
            scopeValueSpecificParameters.forEach(p -> varMan.putVariable(node, VariableType.IMMUTABLE, p.key, (Object)p.value));
        }
    }

    public static void putVariables(ExecutionContext context, ReportNode rootNode, Map<String, ? extends Object> parameters, VariableType type) {
        VariablesManager varMan = context.getVariablesManager();
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                varMan.putVariable(rootNode, type, key, parameters.get(key));
            }
        }
    }
}

