/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.parametermanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import step.commons.activation.ActivableObject;
import step.commons.activation.Activator;
import step.core.accessors.CRUDAccessor;
import step.plugins.parametermanager.Parameter;

public class ParameterManager {
    CRUDAccessor<Parameter> parameterAccessor;

    public ParameterManager(CRUDAccessor<Parameter> parameterAccessor) {
        this.parameterAccessor = parameterAccessor;
    }

    public Map<String, String> getAllParameterValues(Map<String, Object> contextBindings) {
        return this.getAllParameters(contextBindings).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Parameter)((Object)((Object)e.getValue()))).value));
    }

    public Map<String, Parameter> getAllParameters(Map<String, Object> contextBindings) {
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        SimpleBindings bindings = contextBindings != null ? new SimpleBindings(contextBindings) : null;
        HashMap parameterMap = new HashMap();
        this.parameterAccessor.getAll().forEachRemaining(p -> {
            ArrayList<Parameter> parameters = (ArrayList<Parameter>)parameterMap.get(p.key);
            if (parameters == null) {
                parameters = new ArrayList<Parameter>();
                parameterMap.put(p.key, parameters);
            }
            parameters.add((Parameter)((Object)p));
            try {
                Activator.compileActivationExpression((ActivableObject)p);
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
        });
        for (String key : parameterMap.keySet()) {
            List parameters = (List)parameterMap.get(key);
            Parameter bestMatch = (Parameter)Activator.findBestMatch((Map)bindings, (List)parameters);
            if (bestMatch == null) continue;
            result.put(key, bestMatch);
        }
        return result;
    }
}

