/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.datatable;

import com.mongodb.client.model.Filters;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.accessors.CollectionFind;
import step.core.accessors.SearchOrder;
import step.core.deployment.Secured;
import step.core.export.ExportTaskManager;
import step.plugins.datatable.AbstractTableService;
import step.plugins.datatable.BackendDataTable;
import step.plugins.datatable.BackendDataTableDataResponse;
import step.plugins.datatable.ColumnDef;
import step.plugins.datatable.DataTableRegistry;
import step.resources.Resource;
import step.resources.ResourceManager;
import step.resources.ResourceRevisionContainer;

@Singleton
@Path(value="datatable")
public class DataTableServices
extends AbstractTableService {
    private static final Logger logger = LoggerFactory.getLogger(DataTableServices.class);
    protected DataTableRegistry dataTableRegistry;
    protected ExportTaskManager exportTaskManager;
    protected final ExecutorService reportExecutor = Executors.newFixedThreadPool(2);
    Pattern columnSearchPattern = Pattern.compile("columns\\[([0-9]+)\\]\\[search\\]\\[value\\]");
    Pattern searchPattern = Pattern.compile("search\\[value\\]");
    private static final String CSV_DELIMITER = ";";

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
        this.exportTaskManager = new ExportTaskManager((ResourceManager)this.getContext().get(ResourceManager.class));
        this.dataTableRegistry = (DataTableRegistry)this.getContext().get(DataTableRegistry.class);
    }

    @PreDestroy
    public void destroy() {
        this.reportExecutor.shutdown();
    }

    @GET
    @Path(value="/{id}/columns")
    @Produces(value={"application/json"})
    @Secured
    public List<ColumnDef> getTableColumnDefs(@PathParam(value="id") String collectionID) {
        BackendDataTable table = this.dataTableRegistry.getTable(collectionID);
        if (table == null) {
            throw new RuntimeException("Unable to load table definition for entity: " + collectionID);
        }
        return table.getColumns();
    }

    @POST
    @Path(value="/{id}/data")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Secured
    public BackendDataTableDataResponse getTableData_Post(@PathParam(value="id") String collectionID, MultivaluedMap<String, String> form, @Context ContainerRequestContext crc, @QueryParam(value="ignoreContext") String ignoreContext) throws Exception {
        List<Bson> sessionQueryFragments = this.getAdditionalQueryFragmentsFromContext(crc, collectionID, ignoreContext);
        return this.getTableData(collectionID, form, sessionQueryFragments);
    }

    @GET
    @Path(value="/{id}/data")
    @Produces(value={"application/json"})
    @Secured
    public BackendDataTableDataResponse getTableData_Get(@PathParam(value="id") String collectionID, @Context UriInfo uriInfo, @Context ContainerRequestContext crc, @QueryParam(value="ignoreContext") String ignoreContext) throws Exception {
        List<Bson> sessionQueryFragments = this.getAdditionalQueryFragmentsFromContext(crc, collectionID, ignoreContext);
        return this.getTableData(collectionID, (MultivaluedMap<String, String>)uriInfo.getQueryParameters(), sessionQueryFragments);
    }

    private BackendDataTableDataResponse getTableData(@PathParam(value="id") String collectionID, MultivaluedMap<String, String> params, List<Bson> sessionQueryFragments) throws Exception {
        Bson query;
        BackendDataTable table = this.dataTableRegistry.getTable(collectionID);
        ArrayList<Bson> queryFragments = new ArrayList<Bson>();
        for (String key : params.keySet()) {
            String searchValue;
            Matcher m = this.columnSearchPattern.matcher(key);
            Matcher searchMatcher = this.searchPattern.matcher(key);
            if (m.matches()) {
                int columnID = Integer.parseInt(m.group(1));
                ColumnDef column = null;
                try {
                    column = table.getColumnByID(columnID);
                    String searchValue2 = (String)params.getFirst((Object)key);
                    if (searchValue2 == null || searchValue2.length() <= 0 || column.getQueryFactory() == null) continue;
                    queryFragments.add(column.getQueryFactory().createQuery(column.getValue(), searchValue2));
                }
                catch (IndexOutOfBoundsException searchValue2) {}
                continue;
            }
            if (searchMatcher.matches() && (searchValue = (String)params.getFirst((Object)key)) != null && searchValue.length() <= 0) continue;
        }
        int draw = Integer.parseInt((String)params.getFirst((Object)"draw"));
        int skip = Integer.parseInt((String)params.getFirst((Object)"start"));
        int limit = Integer.parseInt((String)params.getFirst((Object)"length"));
        int sortColumnID = Integer.parseInt((String)params.getFirst((Object)"order[0][column]"));
        ColumnDef sortColumn = table.getColumnByID(sortColumnID);
        String sortDir = (String)params.getFirst((Object)"order[0][dir]");
        SearchOrder order = null;
        if (sortColumn.getValue() != null) {
            order = new SearchOrder(sortColumn.getValue(), sortDir.equals("asc") ? 1 : -1);
        }
        if (table.getQuery() != null) {
            Bson fragment;
            JsonObject filter = null;
            if (params.containsKey((Object)"params")) {
                JsonReader reader = Json.createReader((Reader)new StringReader((String)params.getFirst((Object)"params")));
                filter = reader.readObject();
            }
            if ((fragment = table.getQuery().buildAdditionalQuery(filter)) != null) {
                queryFragments.add(fragment);
            }
        }
        if (sessionQueryFragments != null) {
            queryFragments.addAll(sessionQueryFragments);
        }
        Object object = query = queryFragments.size() > 0 ? Filters.and(queryFragments) : new Document();
        if (params.containsKey((Object)"export")) {
            String reportID = (String)params.getFirst((Object)"export");
            this.exportTaskManager.createExportTask(reportID, (ExportTaskManager.ExportRunnable)new ExportTask(table, query, order));
        }
        CollectionFind find = table.getCollection().find(query, order, Integer.valueOf(skip), Integer.valueOf(limit));
        Iterator it = find.getIterator();
        ArrayList objects = new ArrayList();
        while (it.hasNext()) {
            objects.add(it.next());
        }
        String[][] data = new String[objects.size()][table.getColumns().size()];
        for (int i = 0; i < objects.size(); ++i) {
            Document row = (Document)objects.get(i);
            String[] rowFormatted = DataTableServices.formatRow(table.getColumns(), row);
            data[i] = rowFormatted;
        }
        BackendDataTableDataResponse response = new BackendDataTableDataResponse(draw, find.getRecordsTotal(), find.getRecordsFiltered(), data);
        return response;
    }

    private static String[] formatRow(List<ColumnDef> columns, Document row) {
        int columnID = 0;
        String[] rowFormatted = new String[columns.size()];
        for (ColumnDef column : columns) {
            if (column.getValue() != null) {
                String[] keys = column.getValue().split("\\.");
                Object value = row;
                for (String key : keys) {
                    if (value == null) continue;
                    value = value.get((Object)key);
                }
                rowFormatted[columnID] = value != null ? DataTableServices.format(value, row, column) : "";
            } else {
                rowFormatted[columnID] = DataTableServices.format(null, row, column);
            }
            ++columnID;
        }
        return rowFormatted;
    }

    @GET
    @Path(value="/exports/{id}")
    @Produces(value={"application/json"})
    @Secured
    public ExportTaskManager.ExportStatus getExport(@PathParam(value="id") String reportID) throws Exception {
        return this.exportTaskManager.getExportStatus(reportID);
    }

    public static Field getField(String fieldName, Class<?> type) {
        try {
            return type.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (type.getSuperclass() != null) {
                return DataTableServices.getField(fieldName, type.getSuperclass());
            }
            return null;
        }
        catch (SecurityException e) {
            throw e;
        }
    }

    private static String format(Object value, Document row, ColumnDef column) {
        return column.format.format(value, row);
    }

    public static class ExportTask
    extends ExportTaskManager.ExportRunnable {
        protected BackendDataTable table;
        protected Bson query;
        protected SearchOrder order;

        public ExportTask(BackendDataTable table, Bson query, SearchOrder order) {
            this.table = table;
            this.query = query;
            this.order = order;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Resource runExport() throws Exception {
            try {
                CollectionFind find = this.table.getCollection().find(this.query, this.order, null, null);
                ResourceRevisionContainer resourceContainer = this.getResourceManager().createResourceContainer("temp", "export.csv");
                PrintWriter writer = new PrintWriter(resourceContainer.getOutputStream());
                try {
                    List<ColumnDef> columns = this.table.getExportColumns() != null ? this.table.getExportColumns() : this.table.getColumns();
                    for (ColumnDef colDef : columns) {
                        String title = colDef.title.replaceAll("^ID", "id");
                        writer.print(title);
                        writer.print(DataTableServices.CSV_DELIMITER);
                    }
                    writer.println();
                    find.getRecordsFiltered();
                    Iterator it = find.getIterator();
                    int count = 0;
                    while (it.hasNext()) {
                        String[] formattedRow;
                        ++count;
                        Document object = (Document)it.next();
                        for (String val : formattedRow = DataTableServices.formatRow(columns, object)) {
                            if (val.contains(DataTableServices.CSV_DELIMITER) || val.contains("\n") || val.contains("\"")) {
                                val = "\"" + val.replaceAll("\"", "\"\"") + "\"";
                            }
                            writer.print(val);
                            writer.print(DataTableServices.CSV_DELIMITER);
                        }
                        writer.println();
                    }
                }
                finally {
                    writer.close();
                    resourceContainer.save(null);
                }
                return resourceContainer.getResource();
            }
            catch (Exception e) {
                logger.error("An error occurred while generating report", (Throwable)e);
                throw e;
            }
        }
    }
}

