/*
 * Decompiled with CFR 0.152.
 */
package step.handlers.javahandler;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.grid.agent.AgentTokenServices;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.agent.tokenpool.TokenReservationSession;
import step.grid.contextbuilder.ApplicationContextBuilder;
import step.grid.io.InputMessage;
import step.grid.io.OutputMessage;
import step.handlers.javahandler.KeywordHandler;

public class KeywordRunner {
    private static final Logger logger = LoggerFactory.getLogger(KeywordRunner.class);

    public static ExecutionContext getExecutionContext(Class<?> ... functionClass) {
        return KeywordRunner.getExecutionContext(new HashMap<String, String>(), functionClass);
    }

    public static ExecutionContext getExecutionContext(Map<String, String> properties, Class<?> ... keywordClass) {
        if (keywordClass.length == 0) {
            throw new RuntimeException("Please specify at leat one class containing the keyword definitions");
        }
        return new ExecutionContext(Arrays.asList(keywordClass), properties, true);
    }

    public static class ExecutionContext {
        AgentTokenWrapper token;
        KeywordHandler handler;
        List<Class<?>> functionClasses;

        public ExecutionContext(List<Class<?>> functionClasses, Map<String, String> properties, boolean throwExceptionOnError) {
            this.functionClasses = functionClasses;
            this.token = new AgentTokenWrapper();
            if (properties != null) {
                this.token.setProperties(properties);
            }
            this.token.setTokenReservationSession(new TokenReservationSession());
            AgentTokenServices tokenServices = new AgentTokenServices(null);
            tokenServices.setApplicationContextBuilder(new ApplicationContextBuilder());
            this.token.setServices(tokenServices);
            this.handler = new KeywordHandler(throwExceptionOnError);
            this.handler.init(tokenServices);
        }

        public void setThrowExceptionOnError(boolean throwExceptionOnError) {
            this.handler.setThrowExceptionOnError(throwExceptionOnError);
        }

        public OutputMessage run(String function, String argument, Map<String, String> properties) throws Exception {
            return this.run(function, this.read(argument), properties);
        }

        public OutputMessage run(String function, String argument) throws Exception {
            return this.run(function, this.read(argument), new HashMap<String, String>());
        }

        private JsonObject read(String argument) {
            return Json.createReader((Reader)new StringReader(argument)).readObject();
        }

        public OutputMessage run(String function) throws Exception {
            return this.run(function, Json.createObjectBuilder().build(), new HashMap<String, String>());
        }

        public OutputMessage run(String function, JsonObject argument) throws Exception {
            return this.run(function, argument, new HashMap<String, String>());
        }

        public OutputMessage run(String function, JsonObject argument, Map<String, String> properties) throws Exception {
            return this.execute(function, argument, properties);
        }

        private OutputMessage execute(String function, JsonObject argument, Map<String, String> properties) throws Exception {
            InputMessage input = new InputMessage();
            input.setFunction(function);
            input.setArgument(argument);
            StringBuilder classes = new StringBuilder();
            this.functionClasses.forEach(cl -> classes.append(cl.getName() + ";"));
            properties.put("$keywordClasses", classes.toString());
            input.setProperties(properties);
            OutputMessage output = this.handler.handle(this.token, input);
            if (output.getError() != null) {
                logger.error("Keyword error occurred:" + output.getError());
            }
            return output;
        }

        public void close() {
            this.token.getSession().close();
            this.token.getTokenReservationSession().close();
        }
    }
}

