/*
 * Decompiled with CFR 0.152.
 */
package step.handlers.javahandler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.functions.handler.JsonBasedFunctionHandler;
import step.functions.io.Input;
import step.functions.io.Output;
import step.functions.io.OutputBuilder;
import step.handlers.javahandler.AbstractKeyword;
import step.handlers.javahandler.Keyword;
import step.handlers.javahandler.KeywordException;

public class KeywordHandler
extends JsonBasedFunctionHandler {
    public static final String KEYWORD_CLASSES = "$keywordClasses";
    private static final Logger logger = LoggerFactory.getLogger(KeywordHandler.class);
    private boolean throwExceptionOnError = false;

    public KeywordHandler() {
    }

    public KeywordHandler(boolean throwExceptionOnError) {
        this.throwExceptionOnError = throwExceptionOnError;
    }

    public boolean isThrowExceptionOnError() {
        return this.throwExceptionOnError;
    }

    public void setThrowExceptionOnError(boolean throwExceptionOnError) {
        this.throwExceptionOnError = throwExceptionOnError;
    }

    public Output<JsonObject> handle(Input<JsonObject> input) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String kwClassnames = (String)input.getProperties().get(KEYWORD_CLASSES);
        if (kwClassnames != null && kwClassnames.trim().length() > 0) {
            for (String kwClassname : kwClassnames.split(";")) {
                Class<?> kwClass = cl.loadClass(kwClassname);
                for (Method m : kwClass.getDeclaredMethods()) {
                    Keyword annotation;
                    String annotatedFunctionName;
                    if (!m.isAnnotationPresent(Keyword.class) || ((annotatedFunctionName = (annotation = m.getAnnotation(Keyword.class)).name()) != null && annotatedFunctionName.length() != 0 || !m.getName().equals(input.getFunction())) && !annotatedFunctionName.equals(input.getFunction())) continue;
                    return this.invokeMethod(m, input);
                }
            }
        }
        throw new Exception("Unable to find method annoted by '" + Keyword.class.getName() + "' with name=='" + input.getFunction() + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Output<JsonObject> invokeMethod(Method m, Input<JsonObject> input) throws Exception {
        OutputBuilder outputBuilder;
        block9: {
            Class<?> clazz = m.getDeclaringClass();
            Object instance = clazz.newInstance();
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking method " + m.getName() + " from class " + clazz.getName() + " loaded by " + clazz.getClassLoader().toString());
            }
            outputBuilder = new OutputBuilder();
            if (instance instanceof AbstractKeyword) {
                AbstractKeyword script = (AbstractKeyword)instance;
                script.setTokenSession(this.getTokenSession());
                script.setSession(this.getTokenReservationSession());
                script.setInput((JsonObject)input.getPayload());
                script.setProperties(this.mergeAllProperties(input));
                script.setOutputBuilder(outputBuilder);
                try {
                    m.invoke(instance, new Object[0]);
                    break block9;
                }
                catch (Exception e) {
                    boolean throwException = script.onError(e);
                    if (throwException) {
                        Throwable cause = e.getCause();
                        Throwable reportedEx = e instanceof InvocationTargetException && cause != null && cause instanceof Throwable ? cause : e;
                        outputBuilder.setError(reportedEx.getMessage() != null ? reportedEx.getMessage() : "Empty error message", reportedEx);
                        if (this.throwExceptionOnError) {
                            Output output = outputBuilder.build();
                            throw new KeywordException(output, reportedEx);
                        }
                    }
                    break block9;
                }
            }
            outputBuilder.add("Info:", "The class '" + clazz.getName() + "' doesn't extend '" + AbstractKeyword.class.getName() + "'. Extend this class to get input parameters from STEP and return output.");
        }
        Output output = outputBuilder.build();
        if (this.throwExceptionOnError && output.getError() != null) {
            throw new KeywordException(output);
        }
        return output;
    }
}

