/*
 * Decompiled with CFR 0.152.
 */
package step.rtm;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Singleton
@Path(value="rtm")
public class RtmPluginServices {
    @GET
    @Path(value="/rtmlink/{id}")
    @Produces(value={"application/json"})
    public RTMLink getRtmLink(@PathParam(value="id") String executionID) {
        RTMLink link = new RTMLink();
        try {
            link.link = this.getAggregateViewByEid(executionID);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return link;
    }

    private String getAggregateViewByEid(String eid) throws UnsupportedEncodingException {
        return "rtm/#Aggregate/select/" + URLEncoder.encode("{\"guiParams\": {\"postControllerView\": {\"selectors1\": [{\"filters\": [{\"type\": \"text\",\"key\": \"eId\",\"value\": \"" + eid + "\",\"regex\": \"\"}]}]},\"measurementListView\": {\"nextFactor\": \"0\",\"tableMetricChoice\": [\"begin\",\"name\",\"value\"]},\"aggregateSPView\": {\"sessionId\": \"defaultSid\",\"granularity\": \"auto\",\"groupby\": \"name\",\"cpu\": \"1\",\"partition\": \"8\",\"timeout\": \"600\"},\"aggregateGraphView\": {\"chartMetricChoice\": \"AVG\"},\"aggregateTableView\": {\"checkedAggTableMetrics\": [\"begin\",\"CNT\",\"AVG\"],\"isSwitchedOn\": \"false\"}}}", "UTF-8").replace("+", "%20");
    }

    public class RTMLink {
        String link;

        public String getLink() {
            return this.link;
        }
    }
}

