/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.java.handler;

import step.grid.agent.AgentTokenServices;
import step.grid.agent.handler.AbstractMessageHandler;
import step.grid.agent.handler.MessageHandlerPool;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.contextbuilder.ApplicationContextBuilder;
import step.grid.contextbuilder.ApplicationContextFactory;
import step.grid.contextbuilder.LocalResourceApplicationContextFactory;
import step.grid.contextbuilder.RemoteApplicationContextFactory;
import step.grid.filemanager.FileManagerClient;
import step.grid.io.InputMessage;
import step.grid.io.OutputMessage;
import step.plugins.java.handler.JavaJarHandler;
import step.plugins.js223.handler.ScriptHandler;

public class GeneralScriptHandler
extends AbstractMessageHandler {
    private ApplicationContextBuilder appContextBuilder;
    private MessageHandlerPool messageHandlerPool;
    private FileManagerClient fileManagerClient;

    public void init(AgentTokenServices agentTokenServices) {
        super.init(agentTokenServices);
        this.appContextBuilder = agentTokenServices.getApplicationContextBuilder();
        this.messageHandlerPool = new MessageHandlerPool(agentTokenServices);
        this.fileManagerClient = agentTokenServices.getFileManagerClient();
    }

    public OutputMessage handle(AgentTokenWrapper token, InputMessage message) throws Exception {
        String scriptLanguage;
        LocalResourceApplicationContextFactory scriptApiContext = new LocalResourceApplicationContextFactory(((Object)((Object)this)).getClass().getClassLoader(), "script-dev-java.jar");
        this.appContextBuilder.pushContext((ApplicationContextFactory)scriptApiContext);
        FileManagerClient.FileVersionId librariesFileVersion = this.getFileVersionId("$libraries.file", message.getProperties());
        if (librariesFileVersion != null) {
            RemoteApplicationContextFactory librariesContext = new RemoteApplicationContextFactory(this.fileManagerClient, librariesFileVersion);
            this.appContextBuilder.pushContext((ApplicationContextFactory)librariesContext);
        }
        Class handlerClass = (scriptLanguage = (String)message.getProperties().get("$scriptlanguage")).equals("java") ? JavaJarHandler.class : ScriptHandler.class;
        return this.messageHandlerPool.get(handlerClass.getName()).handle(token, message);
    }
}

