/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.java.handler;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;
import step.grid.agent.AgentTokenServices;
import step.grid.agent.handler.AbstractMessageHandler;
import step.grid.agent.handler.MessageHandlerPool;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.contextbuilder.ApplicationContextBuilder;
import step.grid.contextbuilder.ApplicationContextFactory;
import step.grid.contextbuilder.RemoteApplicationContextFactory;
import step.grid.filemanager.FileManagerClient;
import step.grid.io.InputMessage;
import step.grid.io.OutputMessage;
import step.handlers.javahandler.Keyword;
import step.handlers.javahandler.KeywordHandler;

public class JavaJarHandler
extends AbstractMessageHandler {
    private ApplicationContextBuilder appContextBuilder;
    private MessageHandlerPool messageHandlerPool;

    public void init(AgentTokenServices agentTokenServices) {
        super.init(agentTokenServices);
        this.appContextBuilder = agentTokenServices.getApplicationContextBuilder();
        this.messageHandlerPool = new MessageHandlerPool(agentTokenServices);
    }

    public OutputMessage handle(AgentTokenWrapper token, InputMessage message) throws Exception {
        FileManagerClient fmClient = token.getServices().getFileManagerClient();
        FileManagerClient.FileVersionId currentkeywordVersion = this.getFileVersionId("$function.library.file", message.getProperties());
        message.getProperties().put("keywordRootPath", fmClient.getDataFolderPath() + "\\" + currentkeywordVersion.getFileId() + "\\" + currentkeywordVersion.getVersion());
        RemoteApplicationContextFactory scriptJarContext = new RemoteApplicationContextFactory(fmClient, currentkeywordVersion);
        this.appContextBuilder.pushContext((ApplicationContextFactory)scriptJarContext);
        ApplicationContextBuilder.ApplicationContext context = this.agentTokenServices.getApplicationContextBuilder().getCurrentContext();
        String kwClassnames = (String)context.get((Object)"kwClassnames");
        if (kwClassnames == null) {
            kwClassnames = this.getKeywordClassList((URLClassLoader)context.getClassLoader());
            context.put("kwClassnames", (Object)kwClassnames);
        }
        message.getProperties().put("$keywordClasses", kwClassnames);
        return this.messageHandlerPool.get(KeywordHandler.class.getName(), this.appContextBuilder.getCurrentContext().getClassLoader()).handle(token, message);
    }

    private String getKeywordClassList(URLClassLoader cl) throws Exception {
        URL url = cl.getURLs()[0];
        try {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(new URL[]{url}).addClassLoader((ClassLoader)cl).setScanners(new Scanner[]{new MethodAnnotationsScanner()}));
            Set methods = reflections.getMethodsAnnotatedWith(Keyword.class);
            HashSet<String> kwClasses = new HashSet<String>();
            for (Method method : methods) {
                kwClasses.add(method.getDeclaringClass().getName());
            }
            StringBuilder kwClassnamesBuilder = new StringBuilder();
            kwClasses.forEach(kwClassname -> kwClassnamesBuilder.append(kwClassname + ";"));
            return kwClassnamesBuilder.toString();
        }
        catch (Exception e) {
            String errorMsg = "Error while looking for methods annotated with @Keyword in " + url.toString();
            throw new Exception(errorMsg, e);
        }
    }
}

