/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import step.attachments.FileResolver;
import step.commons.conf.Configuration;
import step.functions.type.AbstractFunctionType;
import step.functions.type.SetupFunctionException;
import step.grid.bootstrap.ResourceExtractor;
import step.grid.filemanager.FileManagerClient;
import step.plugins.java.GeneralScriptFunction;
import step.plugins.java.handler.GeneralScriptHandler;

public abstract class AbstractScriptFunctionType<T extends GeneralScriptFunction>
extends AbstractFunctionType<T> {
    File daemonJar;
    public static final Map<String, String> fileExtensionMap = new ConcurrentHashMap<String, String>();
    public static final Map<String, String> scriptEngineMap = new ConcurrentHashMap<String, String>();

    public AbstractScriptFunctionType() {
        fileExtensionMap.put("groovy", "groovy");
        scriptEngineMap.put("groovy", "groovy");
        fileExtensionMap.put("python", "py");
        scriptEngineMap.put("python", "python");
        fileExtensionMap.put("javascript", "js");
        scriptEngineMap.put("javascript", "nashorn");
    }

    public void init() {
        super.init();
        this.daemonJar = ResourceExtractor.extractResource((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"java-plugin-handler.jar");
    }

    public Map<String, String> getHandlerProperties(T function) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("$scriptlanguage", (String)((GeneralScriptFunction)((Object)function)).getScriptLanguage().get());
        this.registerFile(((GeneralScriptFunction)((Object)function)).getLibrariesFile(), "$libraries.file", props);
        this.registerFile(((GeneralScriptFunction)((Object)function)).getScriptFile(), "$function.library.file", props);
        return props;
    }

    public String getHandlerChain(GeneralScriptFunction function) {
        return GeneralScriptHandler.class.getName();
    }

    public FileManagerClient.FileVersionId getHandlerPackage(GeneralScriptFunction function) {
        return this.registerFile(this.daemonJar.getAbsoluteFile());
    }

    protected File getDefaultScriptFile(GeneralScriptFunction function) {
        String filename = this.getScriptFilename(function);
        String scriptDir = Configuration.getInstance().getProperty("keywords.script.scriptdir");
        File file = new File(scriptDir + "/" + filename);
        return file;
    }

    private String getScriptFilename(GeneralScriptFunction function) {
        TreeSet sortedKeys = new TreeSet(function.getAttributes().keySet());
        StringBuilder filename = new StringBuilder();
        Iterator it = sortedKeys.iterator();
        while (it.hasNext()) {
            filename.append((String)function.getAttributes().get(it.next()));
            if (!it.hasNext()) continue;
            filename.append("_");
        }
        filename.append(".").append(fileExtensionMap.get(this.getScriptLanguage(function)));
        return filename.toString();
    }

    protected String getScriptLanguage(GeneralScriptFunction conf) {
        return (String)conf.getScriptLanguage().get();
    }

    protected File setupScriptFile(GeneralScriptFunction function, String templateFilename) throws SetupFunctionException {
        File templateScript = new File(Configuration.getInstance().getProperty("controller.dir") + "/data/templates/" + templateFilename);
        try {
            return this.setupScriptFile(function, new FileInputStream(templateScript));
        }
        catch (FileNotFoundException e) {
            throw new SetupFunctionException("Unable to apply template. The file '" + templateScript.getAbsolutePath() + "' doesn't exist");
        }
    }

    protected File setupScriptFile(GeneralScriptFunction function, InputStream templateStream) throws SetupFunctionException {
        File scriptFile;
        String scriptFilename = (String)function.getScriptFile().get();
        if (scriptFilename == null || scriptFilename.trim().length() == 0) {
            scriptFile = this.getDefaultScriptFile(function);
            function.getScriptFile().setValue((Object)scriptFile.getAbsolutePath());
        } else {
            scriptFile = new File(scriptFilename);
        }
        if (!scriptFile.exists()) {
            File folder = scriptFile.getParentFile();
            if (!folder.exists()) {
                try {
                    Files.createDirectory(folder.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new SetupFunctionException("Unable to create script folder '" + folder.getAbsolutePath() + "' for function '" + (String)function.getAttributes().get("name"), (Throwable)e);
                }
            }
            try {
                scriptFile.createNewFile();
            }
            catch (IOException e) {
                throw new SetupFunctionException("Unable to create script folder '" + folder.getAbsolutePath() + "' for function '" + (String)function.getAttributes().get("name"), (Throwable)e);
            }
            if (templateStream != null) {
                this.applyTemplate(scriptFile, templateStream);
            }
        }
        return scriptFile;
    }

    private void applyTemplate(File scriptFile, InputStream templateScript) throws SetupFunctionException {
        if (templateScript != null) {
            try {
                Files.copy(templateScript, scriptFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new SetupFunctionException("Unable to copy template from stream to '" + scriptFile.getAbsolutePath() + "'", (Throwable)e);
            }
        } else {
            throw new SetupFunctionException("Unable to apply template. The stream is null");
        }
    }

    public File getScriptFile(T function) {
        String scriptFilePath = (String)((GeneralScriptFunction)((Object)function)).getScriptFile().get();
        FileResolver fileResolver = new FileResolver(this.context.getAttachmentManager());
        return fileResolver.resolve(scriptFilePath);
    }
}

