/*
 * Decompiled with CFR 0.152.
 */
package step.initialization;

import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.artefacts.CallFunction;
import step.core.GlobalContext;
import step.core.access.User;
import step.core.access.UserAccessorImpl;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.dynamicbeans.DynamicValue;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.functions.Function;
import step.functions.accessor.FunctionCRUDAccessor;
import step.plugins.java.GeneralScriptFunction;
import step.plugins.jmeter.JMeterFunction;
import step.plugins.selenium.SeleniumFunction;
import step.versionmanager.VersionManager;

@Plugin(prio=2)
public class InitializationPlugin
extends AbstractPlugin {
    private static final Logger logger = LoggerFactory.getLogger(InitializationPlugin.class);

    public void executionControllerStart(GlobalContext context) throws Exception {
        VersionManager versionManager = (VersionManager)context.get(VersionManager.class);
        if (versionManager.getLatestControllerLog() == null) {
            logger.info("Initializing Users...");
            this.setupUsers(context);
        }
        super.executionControllerStart(context);
    }

    private void setupUsers(GlobalContext context) {
        User user = new User();
        user.setUsername("admin");
        user.setRole("admin");
        user.setPassword(UserAccessorImpl.encryptPwd((String)"init"));
        context.getUserAccessor().save((AbstractIdentifiableObject)user);
    }

    private CallFunction createCallFunctionById(String functionId, String args) {
        CallFunction call1 = new CallFunction();
        call1.setFunctionId(functionId);
        call1.setArgument(new DynamicValue((Object)args));
        return call1;
    }

    private Function addScriptFunction(FunctionCRUDAccessor functionRepository, String name, String scriptLanguage, String scriptFile) {
        return this.addScriptFunction(functionRepository, name, scriptLanguage, scriptFile, null);
    }

    private Function addScriptFunction(FunctionCRUDAccessor functionRepository, String name, String scriptLanguage, String scriptFile, JsonObject schema) {
        GeneralScriptFunction function = new GeneralScriptFunction();
        HashMap<String, String> kwAttributes = new HashMap<String, String>();
        kwAttributes.put("name", name);
        function.setAttributes(kwAttributes);
        function.getScriptLanguage().setValue((Object)scriptLanguage);
        function.getScriptFile().setValue((Object)scriptFile);
        if (schema != null) {
            function.setSchema(schema);
        } else {
            function.setSchema(Json.createObjectBuilder().build());
        }
        functionRepository.save((AbstractIdentifiableObject)function);
        return function;
    }

    private Function addSeleniumFunction(FunctionCRUDAccessor functionRepository, String name, String scriptLanguage, String scriptFile) {
        SeleniumFunction function = new SeleniumFunction();
        HashMap<String, String> kwAttributes = new HashMap<String, String>();
        kwAttributes.put("name", name);
        function.setAttributes(kwAttributes);
        function.getScriptLanguage().setValue((Object)scriptLanguage);
        function.getScriptFile().setValue((Object)scriptFile);
        function.setSeleniumVersion("3.x");
        functionRepository.save((AbstractIdentifiableObject)function);
        return function;
    }

    private Function addJMeterFunction(FunctionCRUDAccessor functionRepository, String name, String jmeterFile) {
        JMeterFunction function = new JMeterFunction();
        HashMap<String, String> kwAttributes = new HashMap<String, String>();
        kwAttributes.put("name", name);
        function.setAttributes(kwAttributes);
        function.getJmeterTestplan().setValue((Object)jmeterFile);
        functionRepository.save((AbstractIdentifiableObject)function);
        return function;
    }
}

