/*
 * Decompiled with CFR 0.152.
 */
package step.migration.tasks;

import com.mongodb.Block;
import com.mongodb.client.MongoCollection;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.Document;
import org.bson.conversions.Bson;
import step.core.GlobalContext;
import step.core.Version;
import step.migration.MigrationTask;

public class RenameArtefactType
extends MigrationTask {
    public RenameArtefactType() {
        super(new Version(3, 5, 0));
    }

    @Override
    public void runUpgradeScript() {
        this.renameArtefactType(this.context, "FunctionGroup", "Session");
        this.renameArtefactType(this.context, "CallFunction", "CallKeyword");
    }

    private void renameArtefactType(GlobalContext context, final String classFrom, final String classTo) {
        logger.info("Searching for artefacts of type '" + classFrom + "' to be migrated...");
        final MongoCollection artefacts = context.getMongoClientSession().getMongoDatabase().getCollection("artefacts");
        final AtomicInteger i = new AtomicInteger();
        Document filterCallFunction = new Document("_class", (Object)classFrom);
        artefacts.find((Bson)filterCallFunction).forEach((Block)new Block<Document>(){

            public void apply(Document t) {
                try {
                    i.incrementAndGet();
                    t.put("_class", (Object)classTo);
                    Document filter = new Document("_id", t.get((Object)"_id"));
                    artefacts.replaceOne((Bson)filter, (Object)t);
                    logger.info("Migrating " + classFrom + " to " + t.toJson());
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
        logger.info("Migrated " + i.get() + " artefacts of type '" + classFrom + "'");
    }

    @Override
    public void runDowngradeScript() {
    }
}

