/*
 * Decompiled with CFR 0.152.
 */
package step.grid.agent.handler.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import step.grid.io.Measure;

public class MeasurementsBuilder {
    private Stack<Measure> stack = new Stack();
    private List<Measure> closedMeasures = new ArrayList<Measure>();

    public void startMeasure(String name) {
        this.pushMeasure(new Measure(name, 0L, System.currentTimeMillis(), null));
    }

    public void startMeasure(String name, long begin) {
        this.pushMeasure(new Measure(name, 0L, begin, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushMeasure(Measure tr) {
        Stack<Measure> stack = this.stack;
        synchronized (stack) {
            this.stack.push(tr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Measure stopMeasure(long end, Map<String, Object> data) {
        Measure tr = null;
        List<Measure> list = this.stack;
        synchronized (list) {
            tr = this.stack.pop();
        }
        if (tr != null) {
            tr.setDuration(end - tr.getBegin());
            tr.setData(data);
            list = this.closedMeasures;
            synchronized (list) {
                this.closedMeasures.add(tr);
            }
        } else {
            throw new RuntimeException("No measure has been started. Please ensure to first call startMeasure before calling stopMeasure.");
        }
        return tr;
    }

    public Measure stopMeasure(Map<String, Object> data) {
        return this.stopMeasure(System.currentTimeMillis(), data);
    }

    public Measure stopMeasure() {
        return this.stopMeasure(null);
    }

    public void addMeasure(String measureName, long aDurationMillis) {
        this.addMeasure(measureName, aDurationMillis, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMeasure(String measureName, long aDurationMillis, Map<String, Object> data) {
        List<Measure> list = this.closedMeasures;
        synchronized (list) {
            this.closedMeasures.add(new Measure(measureName, aDurationMillis, System.currentTimeMillis(), data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMeasure(Measure measure) {
        List<Measure> list = this.closedMeasures;
        synchronized (list) {
            this.closedMeasures.add(measure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMeasures(List<Measure> measures) {
        List<Measure> list = this.closedMeasures;
        synchronized (list) {
            this.closedMeasures.addAll(measures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Measure> getMeasures() {
        List<Measure> list = this.closedMeasures;
        synchronized (list) {
            return new ArrayList<Measure>(this.closedMeasures);
        }
    }
}

