/*
 * Decompiled with CFR 0.152.
 */
package step.grid.agent.handler.context;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.spi.JsonProvider;
import step.grid.agent.handler.context.MeasurementsBuilder;
import step.grid.io.Attachment;
import step.grid.io.AttachmentHelper;
import step.grid.io.Measure;
import step.grid.io.OutputMessage;

public class OutputMessageBuilder {
    private JsonObjectBuilder payloadBuilder = jprov.createObjectBuilder();
    private String payloadJson;
    private MeasurementsBuilder measureHelper = new MeasurementsBuilder();
    private String error;
    private List<Attachment> attachments;
    private static JsonProvider jprov = JsonProvider.provider();
    private Measure lastMeasureHandle = null;

    public JsonObjectBuilder getPayloadBuilder() {
        return this.payloadBuilder;
    }

    public void setPayloadBuilder(JsonObjectBuilder payloadBuilder) {
        this.payloadBuilder = payloadBuilder;
    }

    public OutputMessageBuilder add(String arg0, boolean arg1) {
        this.payloadBuilder.add(arg0, arg1);
        return this;
    }

    public OutputMessageBuilder add(String arg0, double arg1) {
        this.payloadBuilder.add(arg0, arg1);
        return this;
    }

    public OutputMessageBuilder add(String arg0, int arg1) {
        this.payloadBuilder.add(arg0, arg1);
        return this;
    }

    public OutputMessageBuilder add(String arg0, long arg1) {
        this.payloadBuilder.add(arg0, arg1);
        return this;
    }

    public OutputMessageBuilder add(String arg0, String arg1) {
        this.payloadBuilder.add(arg0, arg1);
        return this;
    }

    public OutputMessageBuilder setError(String technicalError) {
        this.error = technicalError;
        return this;
    }

    public OutputMessageBuilder appendError(String technicalError) {
        this.error = this.error != null ? this.error + technicalError : technicalError;
        return this;
    }

    public String getPayloadJson() {
        return this.payloadJson;
    }

    public void setPayloadJson(String payloadJson) {
        this.payloadJson = payloadJson;
    }

    public OutputMessageBuilder setError(String errorMessage, Throwable e) {
        this.setError(errorMessage);
        this.addAttachment(this.generateAttachmentForException(e));
        return this;
    }

    public void addAttachments(List<Attachment> attachments) {
        this.createAttachmentListIfNeeded();
        attachments.addAll(attachments);
    }

    public void addAttachment(Attachment attachment) {
        this.createAttachmentListIfNeeded();
        this.attachments.add(attachment);
    }

    private void createAttachmentListIfNeeded() {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
    }

    public void startMeasure(String id) {
        this.measureHelper.startMeasure(id);
    }

    public void startMeasure(String id, long begin) {
        this.measureHelper.startMeasure(id, begin);
    }

    public void addMeasure(String measureName, long durationMillis) {
        this.measureHelper.addMeasure(measureName, durationMillis);
    }

    public void addMeasure(String measureName, long aDurationMillis, Map<String, Object> data) {
        this.measureHelper.addMeasure(measureName, aDurationMillis, data);
    }

    public void stopMeasure() {
        this.measureHelper.stopMeasure();
    }

    public void stopMeasure(Map<String, Object> data) {
        this.measureHelper.stopMeasure(data);
    }

    public void stopMeasureForAdditionalData() {
        this.lastMeasureHandle = this.measureHelper.stopMeasure();
    }

    public void setLastMeasureAdditionalData(Map<String, Object> data) {
        this.lastMeasureHandle.setData(data);
        this.lastMeasureHandle = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputMessage build() {
        JsonObject payload;
        OutputMessage message = new OutputMessage();
        if (this.payloadJson == null) {
            payload = this.payloadBuilder.build();
        } else {
            try (JsonReader reader = Json.createReader((Reader)new StringReader(this.payloadJson));){
                payload = reader.readObject();
            }
        }
        message.setPayload(payload);
        message.setMeasures(this.measureHelper.getMeasures());
        message.setAttachments(this.attachments);
        message.setError(this.error);
        return message;
    }

    private Attachment generateAttachmentForException(Throwable e) {
        Attachment attachment = new Attachment();
        attachment.setName("exception.log");
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        attachment.setHexContent(AttachmentHelper.getHex(w.toString().getBytes()));
        return attachment;
    }
}

