/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.views.functions;

import step.artefacts.reports.CallFunctionReportNode;
import step.core.artefacts.reports.ReportNode;
import step.plugins.views.AbstractView;
import step.plugins.views.View;
import step.plugins.views.functions.ErrorDistribution;

@View
public class ErrorDistributionView
extends AbstractView<ErrorDistribution> {
    private int otherThreshhold = 500;

    @Override
    public void afterReportNodeSkeletonCreation(ErrorDistribution model, ReportNode node) {
    }

    @Override
    public void afterReportNodeExecution(ErrorDistribution model, ReportNode node) {
        if (node instanceof CallFunctionReportNode) {
            model.setCount(model.getCount() + 1L);
            if (node.getError() != null && node.getError().getMsg() != null) {
                model.setErrorCount(model.getErrorCount() + 1L);
                String key = node.getError().getMsg();
                Integer count = (Integer)model.countByErrorMsg.get((Object)key);
                if (count == null) {
                    if (model.countByErrorMsg.size() < this.otherThreshhold) {
                        model.countByErrorMsg.put((Object)key, (Object)1);
                    } else {
                        Integer currentOtherCount = (Integer)model.countByErrorMsg.get((Object)"Other");
                        if (currentOtherCount == null) {
                            currentOtherCount = 0;
                        }
                        model.countByErrorMsg.put((Object)"Other", (Object)(currentOtherCount + 1));
                    }
                } else {
                    model.countByErrorMsg.put((Object)key, (Object)(count + 1));
                }
            }
        }
    }

    @Override
    public ErrorDistribution init() {
        return new ErrorDistribution();
    }

    @Override
    public String getViewId() {
        return "errorDistribution";
    }
}

