/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.screentemplating;

import java.util.Arrays;
import step.core.GlobalContext;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.plugins.screentemplating.Input;
import step.plugins.screentemplating.InputType;
import step.plugins.screentemplating.Option;
import step.plugins.screentemplating.ScreenInput;
import step.plugins.screentemplating.ScreenInputAccessor;
import step.plugins.screentemplating.ScreenInputAccessorImpl;
import step.plugins.screentemplating.ScreenTemplateManager;
import step.plugins.screentemplating.ScreenTemplateService;

@Plugin
public class ScreenTemplatePlugin
extends AbstractPlugin {
    protected ScreenTemplateManager screenTemplateManager;
    protected ScreenInputAccessor screenInputAccessor;

    public void executionControllerStart(GlobalContext context) {
        this.screenInputAccessor = new ScreenInputAccessorImpl(context.getMongoClientSession());
        this.screenTemplateManager = new ScreenTemplateManager(this.screenInputAccessor);
        this.initializeScreenInputsIfNecessary();
        context.put(ScreenInputAccessor.class, (Object)this.screenInputAccessor);
        context.put(ScreenTemplateManager.class, (Object)this.screenTemplateManager);
        context.getServiceRegistrationCallback().registerService(ScreenTemplateService.class);
    }

    private void initializeScreenInputsIfNecessary() {
        if (this.screenInputAccessor.getScreenInputsByScreenId("artefactTable").isEmpty()) {
            this.screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput("artefactTable", new Input(InputType.TEXT, "attributes.name", "Name", null)));
        }
        if (this.screenInputAccessor.getScreenInputsByScreenId("functionTable").isEmpty()) {
            this.screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput("functionTable", new Input(InputType.TEXT, "name", "Name", null)));
        }
        if (this.screenInputAccessor.getScreenInputsByScreenId("executionTable").isEmpty()) {
            this.screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput("executionTable", new Input(InputType.TEXT, "executionParameters.customParameters.env", "Environment", null)));
        }
        if (this.screenInputAccessor.getScreenInputsByScreenId("executionParameters").isEmpty()) {
            this.screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput("executionParameters", new Input(InputType.DROPDOWN, "env", "Environment", Arrays.asList(new Option("TEST"), new Option("PROD")))));
        }
    }
}

