/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.functions.types;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import javax.json.Json;
import step.core.GlobalContext;
import step.core.accessors.AbstractCRUDAccessor;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.functions.Function;
import step.functions.accessor.FunctionAccessor;
import step.functions.base.types.LocalFunction;
import step.functions.base.types.LocalFunctionType;
import step.functions.base.types.handler.BaseFunctionReflectionHelper;
import step.functions.editors.FunctionEditor;
import step.functions.editors.FunctionEditorRegistry;
import step.functions.type.AbstractFunctionType;
import step.functions.type.FunctionTypeRegistry;
import step.plugins.functions.types.CompositeFunction;
import step.plugins.functions.types.CompositeFunctionType;

@Plugin(prio=10)
public class BaseFunctionTypesPlugin
extends AbstractPlugin {
    public void executionControllerStart(GlobalContext context) throws Exception {
        super.executionControllerStart(context);
        FunctionTypeRegistry functionTypeRegistry = (FunctionTypeRegistry)context.get(FunctionTypeRegistry.class);
        functionTypeRegistry.registerFunctionType((AbstractFunctionType)new CompositeFunctionType(context.getArtefactAccessor(), context.getArtefactManager()));
        functionTypeRegistry.registerFunctionType((AbstractFunctionType)new LocalFunctionType());
        ((FunctionEditorRegistry)context.get(FunctionEditorRegistry.class)).register(new FunctionEditor(){

            public String getEditorPath(Function function) {
                return "/root/artefacteditor/" + ((CompositeFunction)function).getArtefactId();
            }

            public boolean isValidForFunction(Function function) {
                return function instanceof CompositeFunction;
            }
        });
        this.setupLocalFunctionsIfNotExisting(context);
    }

    protected void setupLocalFunctionsIfNotExisting(GlobalContext context) {
        AbstractCRUDAccessor functionAccessor = (AbstractCRUDAccessor)context.get(FunctionAccessor.class);
        List keywordList = null;
        try {
            keywordList = BaseFunctionReflectionHelper.getLocalKeywordList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (keywordList != null) {
            for (String keyword : keywordList) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("name", keyword);
                Function function = (Function)functionAccessor.findByAttributes(attributes);
                if (function != null) continue;
                function = new LocalFunction();
                function.setAttributes(attributes);
                try {
                    function.setSchema(Json.createReader((Reader)new StringReader((String)BaseFunctionReflectionHelper.getLocalKeywordsWithSchemas().get(keyword))).readObject());
                }
                catch (Exception e) {
                    function.setSchema(Json.createReader((Reader)new StringReader("{}")).readObject());
                }
                functionAccessor.save((AbstractIdentifiableObject)function);
            }
        }
    }
}

