/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.parametermanager;

import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.bson.types.ObjectId;
import step.commons.activation.Expression;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.CRUDAccessor;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.plugins.parametermanager.Parameter;

@Path(value="/parameters")
public class ParameterServices
extends AbstractServices {
    CRUDAccessor<Parameter> parameterAccessor;
    public static final String PROTECTED_VALUE = "******";

    @PostConstruct
    public void init() {
        this.parameterAccessor = (CRUDAccessor)this.getContext().get((Object)"ParameterAccessor");
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/")
    @Secured(right="param-write")
    public Parameter newParameter() {
        Parameter parameter = new Parameter(new Expression(""), "", "", "");
        parameter.setPriority(1);
        return parameter;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/")
    @Secured(right="param-write")
    public Parameter save(Parameter newParameter) {
        Parameter oldParameter = newParameter.getId() != null ? (Parameter)this.parameterAccessor.get(newParameter.getId()) : null;
        if (oldParameter == null) {
            newParameter.setProtectedValue(ParameterServices.isPassword(newParameter));
        } else {
            if (newParameter.getValue().equals(PROTECTED_VALUE)) {
                newParameter.setValue(oldParameter.getValue());
            }
            if (this.isProtected(oldParameter)) {
                newParameter.setProtectedValue(true);
            } else {
                newParameter.setProtectedValue(ParameterServices.isPassword(newParameter));
            }
        }
        return (Parameter)this.parameterAccessor.save((AbstractIdentifiableObject)newParameter);
    }

    protected boolean isProtected(Parameter oldParameter) {
        return oldParameter.getProtectedValue() != null && oldParameter.getProtectedValue() != false;
    }

    @POST
    @Path(value="/{id}/copy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="param-write")
    public Parameter copy(@PathParam(value="id") String id) {
        Parameter parameter = (Parameter)this.parameterAccessor.get(new ObjectId(id));
        parameter.setId(new ObjectId());
        return this.save(parameter);
    }

    @DELETE
    @Path(value="/{id}")
    @Secured(right="param-delete")
    public void delete(@PathParam(value="id") String id) {
        this.parameterAccessor.remove(new ObjectId(id));
    }

    public static boolean isPassword(Parameter parameter) {
        return parameter != null && ParameterServices.isPassword(parameter.getKey());
    }

    public static boolean isPassword(String key) {
        return key != null && (key.contains("pwd") || key.contains("password"));
    }

    @GET
    @Path(value="/{id}")
    @Secured(right="param-read")
    public Parameter get(@PathParam(value="id") String id) {
        Parameter parameter = (Parameter)this.parameterAccessor.get(new ObjectId(id));
        if (parameter != null && this.isProtected(parameter)) {
            parameter.setValue(PROTECTED_VALUE);
        }
        return parameter;
    }
}

