/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.quotamanager;

import java.io.File;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import step.common.managedoperations.OperationManager;
import step.commons.conf.Configuration;
import step.commons.conf.FileWatchService;
import step.core.GlobalContext;
import step.core.artefacts.reports.ReportNode;
import step.core.execution.ExecutionContext;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.plugins.quotamanager.QuotaManager;
import step.plugins.quotamanager.QuotaManagerServices;

@Plugin
public class QuotaManagerPlugin
extends AbstractPlugin {
    private ConcurrentHashMap<String, UUID> permits = new ConcurrentHashMap();
    private OperationManager operationManager = OperationManager.getInstance();
    private QuotaManager quotaManager;
    private boolean enabled = false;

    public void beforeReportNodeExecution(ExecutionContext context, ReportNode node) {
        if (this.enabled) {
            UUID permit;
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            bindings.putAll(context.getVariablesManager().getAllVariables());
            bindings.put("node", node);
            this.operationManager.enter("Waiting for quota", new Object());
            try {
                permit = this.quotaManager.acquirePermit(bindings);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while getting permit from quota manager", e);
            }
            finally {
                this.operationManager.exit();
            }
            this.permits.put(node.getId().toString(), permit);
        }
    }

    public void afterReportNodeExecution(ReportNode node) {
        UUID permit;
        if (this.enabled && (permit = this.permits.remove(node.getId().toString())) != null) {
            this.quotaManager.releasePermit(permit);
        }
    }

    private QuotaManager initQuotaManager(String config) {
        final File configFile = new File(config);
        this.quotaManager = new QuotaManager(configFile);
        FileWatchService.getInstance().register(configFile, new Runnable(){

            @Override
            public void run() {
                QuotaManagerPlugin.this.quotaManager.loadConfiguration(configFile);
            }
        });
        return this.quotaManager;
    }

    public void executionControllerStart(GlobalContext context) {
        context.getServiceRegistrationCallback().registerService(QuotaManagerServices.class);
        String config = Configuration.getInstance().getProperty("quotamanager.config");
        if (config != null) {
            QuotaManager manager = this.initQuotaManager(config);
            context.put(QuotaManager.class, (Object)manager);
            this.enabled = true;
        }
    }
}

