/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.datatable.formatters.custom;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Iterator;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeAccessor;
import step.core.deployment.JacksonMapperProvider;
import step.plugins.datatable.formatters.Formatter;

public class RootReportNodeFormatter
implements Formatter {
    protected ReportNodeAccessor reportNodeAccessor;
    protected ObjectMapper mapper;
    private static final Logger logger = LoggerFactory.getLogger(RootReportNodeFormatter.class);

    public RootReportNodeFormatter(GlobalContext context) {
        this.reportNodeAccessor = context.getReportAccessor();
        this.mapper = JacksonMapperProvider.createMapper();
    }

    @Override
    public String format(Object value, Document row) {
        String eid = row.get((Object)"_id").toString();
        ReportNode rootReportNode = this.reportNodeAccessor.getRootReportNode(eid);
        Iterator rootReportNodeChildren = this.reportNodeAccessor.getChildren(rootReportNode.getId());
        if (rootReportNodeChildren.hasNext()) {
            rootReportNode = (ReportNode)rootReportNodeChildren.next();
            if (rootReportNode != null) {
                try {
                    return this.mapper.writeValueAsString((Object)rootReportNode);
                }
                catch (JsonProcessingException e) {
                    logger.error("Error while serializing report node " + rootReportNode, (Throwable)e);
                }
            } else {
                logger.error("Unable to find root report node for execution " + eid);
            }
        } else {
            logger.error("No children found for report node with id " + rootReportNode.getId());
        }
        return "{}";
    }

    @Override
    public Object parse(String formattedValue) {
        throw new RuntimeException("Not implemented");
    }
}

