/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.datatable;

import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.accessors.Collection;
import step.core.accessors.CollectionFind;
import step.core.accessors.SearchOrder;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.execution.model.ExecutionStatus;
import step.core.export.ExportTaskManager;
import step.plugins.datatable.BackendDataTable;
import step.plugins.datatable.BackendDataTableDataResponse;
import step.plugins.datatable.CollectionQueryFactory;
import step.plugins.datatable.ColumnBuilder;
import step.plugins.datatable.ColumnDef;
import step.plugins.datatable.DataTableRegistry;
import step.plugins.datatable.LeafReportNodesFilter;
import step.plugins.datatable.OQLFilter;
import step.plugins.datatable.formatters.custom.ExecutionSummaryFormatter;
import step.plugins.screentemplating.Input;
import step.plugins.screentemplating.ScreenTemplatePlugin;

@Singleton
@Path(value="datatable")
public class DataTableServices
extends AbstractServices {
    private static final Logger logger = LoggerFactory.getLogger(DataTableServices.class);
    protected DataTableRegistry dataTableRegistry;
    protected ExportTaskManager exportTaskManager;
    ExecutorService reportExecutor = Executors.newFixedThreadPool(2);
    Pattern columnSearchPattern = Pattern.compile("columns\\[([0-9]+)\\]\\[search\\]\\[value\\]");
    Pattern searchPattern = Pattern.compile("search\\[value\\]");
    private static final String CSV_DELIMITER = ";";

    @PostConstruct
    public void init() {
        this.exportTaskManager = new ExportTaskManager(this.getContext().getAttachmentManager());
        MongoDatabase database = this.getContext().getMongoClientSession().getMongoDatabase();
        this.dataTableRegistry = (DataTableRegistry)this.getContext().get(DataTableRegistry.class);
        BackendDataTable executions = new BackendDataTable(new Collection(database, "executions"));
        executions.addColumn("ID", "_id").addColumn("Description", "description").addDateColumn("Start time", "startTime").addDateColumn("End time", "endTime").addColumn("User", "executionParameters.userID");
        ScreenTemplatePlugin screenTemplates = (ScreenTemplatePlugin)((Object)this.getContext().get((Object)"ScreenTemplatePlugin_Instance"));
        if (screenTemplates != null) {
            for (Input input : screenTemplates.getInputsForScreen("executionTable", null)) {
                executions.addColumn(input.getLabel(), input.getId());
            }
        }
        executions.addTextWithDropdownColumn("Status", "status", Arrays.asList(ExecutionStatus.values()).stream().map(Object::toString).collect(Collectors.toList()));
        executions.addCustomColumn("Summary", new ExecutionSummaryFormatter(this.controller.getContext()));
        ColumnBuilder leafReportNodesColumns = new ColumnBuilder();
        leafReportNodesColumns.addDateColumn("Begin", "executionTime").addColumn("Name", "name").addJsonColumn("Keyword", "functionAttributes").addColumn("Status", "status").addColumn("Error", "error").addColumn("Input", "input").addColumn("Output", "output").addColumn("Duration", "duration").addColumn("Adapter", "adapter");
        ArrayList<String> reportSearchAttributes = new ArrayList<String>();
        if (screenTemplates != null) {
            for (Input input : screenTemplates.getInputsForScreen("functionTable", null)) {
                reportSearchAttributes.add("functionAttributes." + input.getId());
            }
        }
        reportSearchAttributes.add("input");
        reportSearchAttributes.add("output");
        reportSearchAttributes.add("error.msg");
        reportSearchAttributes.add("name");
        BackendDataTable leafReportNodes = new BackendDataTable(new Collection(database, "reports"));
        leafReportNodes.addColumn("ID", "_id").addTimeColumn("Begin", "executionTime").addRowAsJson("Step", reportSearchAttributes).addTextWithDropdownColumnOptimized("Status", "status", Arrays.asList(ReportNodeStatus.values()).stream().map(Object::toString).collect(Collectors.toList())).setQuery(new LeafReportNodesFilter()).setExportColumns(leafReportNodesColumns.build());
        BackendDataTable artefactTable = new BackendDataTable(new Collection(database, "artefacts"));
        artefactTable.addColumn("ID", "_id");
        if (screenTemplates != null) {
            for (Input input : screenTemplates.getInputsForScreen("artefactTable", null)) {
                artefactTable.addColumn(input.getLabel(), input.getId());
            }
        }
        artefactTable.addColumn("Type", "_class").addRowAsJson("Actions");
        artefactTable.setQuery(new CollectionQueryFactory(){

            @Override
            public Bson buildAdditionalQuery(JsonObject filter) {
                return new Document("root", (Object)true);
            }
        });
        BackendDataTable functionTable = new BackendDataTable(new Collection(database, "functions"));
        functionTable.addColumn("ID", "_id");
        if (screenTemplates != null) {
            for (Input input : screenTemplates.getInputsForScreen("functionTable", null)) {
                functionTable.addColumn(input.getLabel(), "attributes." + input.getId());
            }
        }
        functionTable.addColumn("Type", "type");
        functionTable.addRowAsJson("Actions");
        BackendDataTable backendDataTable = new BackendDataTable(new Collection(database, "reports"));
        backendDataTable.addColumn("ID", "_id").addColumn("Execution", "executionID").addTimeColumn("Begin", "executionTime").addRowAsJson("Step", reportSearchAttributes).addArrayColumn("Attachments", "attachments").addTextWithDropdownColumn("Status", "status", Arrays.asList(ReportNodeStatus.values()).stream().map(Object::toString).collect(Collectors.toList())).setQuery(new OQLFilter()).setExportColumns(leafReportNodesColumns.build());
        this.dataTableRegistry.addTable("executions", executions);
        this.dataTableRegistry.addTable("reports", leafReportNodes);
        this.dataTableRegistry.addTable("reportsByOQL", backendDataTable);
        this.dataTableRegistry.addTable("artefacts", artefactTable);
        this.dataTableRegistry.addTable("functions", functionTable);
    }

    @PreDestroy
    public void destroy() {
        this.reportExecutor.shutdown();
    }

    @GET
    @Path(value="/{id}/columns")
    @Produces(value={"application/json"})
    @Secured
    public List<ColumnDef> getTableColumnDefs(@PathParam(value="id") String collectionID) {
        BackendDataTable table = this.dataTableRegistry.getTable(collectionID);
        return table.getColumns();
    }

    @POST
    @Path(value="/{id}/data")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Secured
    public BackendDataTableDataResponse getTableData_Post(@PathParam(value="id") String collectionID, MultivaluedMap<String, String> form) throws Exception {
        return this.getTableData(collectionID, form);
    }

    @GET
    @Path(value="/{id}/data")
    @Produces(value={"application/json"})
    @Secured
    public BackendDataTableDataResponse getTableData_Get(@PathParam(value="id") String collectionID, @Context UriInfo uriInfo) throws Exception {
        return this.getTableData(collectionID, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
    }

    private BackendDataTableDataResponse getTableData(@PathParam(value="id") String collectionID, MultivaluedMap<String, String> params) throws Exception {
        Bson query;
        BackendDataTable table = this.dataTableRegistry.getTable(collectionID);
        ArrayList<Bson> queryFragments = new ArrayList<Bson>();
        for (String key : params.keySet()) {
            String searchValue;
            Matcher m = this.columnSearchPattern.matcher(key);
            Matcher searchMatcher = this.searchPattern.matcher(key);
            if (m.matches()) {
                int columnID = Integer.parseInt(m.group(1));
                ColumnDef column = table.getColumnByID(columnID);
                String searchValue2 = (String)params.getFirst((Object)key);
                if (searchValue2 == null || searchValue2.length() <= 0 || column.getQueryFactory() == null) continue;
                queryFragments.add(column.getQueryFactory().createQuery(column.getValue(), searchValue2));
                continue;
            }
            if (searchMatcher.matches() && (searchValue = (String)params.getFirst((Object)key)) != null && searchValue.length() <= 0) continue;
        }
        int draw = Integer.parseInt((String)params.getFirst((Object)"draw"));
        int skip = Integer.parseInt((String)params.getFirst((Object)"start"));
        int limit = Integer.parseInt((String)params.getFirst((Object)"length"));
        int sortColumnID = Integer.parseInt((String)params.getFirst((Object)"order[0][column]"));
        ColumnDef sortColumn = table.getColumnByID(sortColumnID);
        String sortDir = (String)params.getFirst((Object)"order[0][dir]");
        SearchOrder order = null;
        if (sortColumn.getValue() != null) {
            order = new SearchOrder(sortColumn.getValue(), sortDir.equals("asc") ? 1 : -1);
        }
        if (table.getQuery() != null) {
            Bson fragment;
            JsonObject filter = null;
            if (params.containsKey((Object)"params")) {
                JsonReader reader = Json.createReader((Reader)new StringReader((String)params.getFirst((Object)"params")));
                filter = reader.readObject();
            }
            if ((fragment = table.getQuery().buildAdditionalQuery(filter)) != null) {
                queryFragments.add(fragment);
            }
        }
        Object object = query = queryFragments.size() > 0 ? Filters.and(queryFragments) : new Document();
        if (params.containsKey((Object)"export")) {
            String reportID = (String)params.getFirst((Object)"export");
            this.exportTaskManager.createExportTask(reportID, (ExportTaskManager.ExportRunnable)new ExportTask(table, query, order));
        }
        CollectionFind find = table.getCollection().find(query, order, Integer.valueOf(skip), Integer.valueOf(limit));
        Iterator it = find.getIterator();
        ArrayList objects = new ArrayList();
        while (it.hasNext()) {
            objects.add(it.next());
        }
        String[][] data = new String[objects.size()][table.getColumns().size()];
        for (int i = 0; i < objects.size(); ++i) {
            Document row = (Document)objects.get(i);
            String[] rowFormatted = DataTableServices.formatRow(table.getColumns(), row);
            data[i] = rowFormatted;
        }
        BackendDataTableDataResponse response = new BackendDataTableDataResponse(draw, find.getRecordsTotal(), find.getRecordsFiltered(), data);
        return response;
    }

    private static String[] formatRow(List<ColumnDef> columns, Document row) {
        int columnID = 0;
        String[] rowFormatted = new String[columns.size()];
        for (ColumnDef column : columns) {
            if (column.getValue() != null) {
                String[] keys = column.getValue().split("\\.");
                Object value = row;
                for (String key : keys) {
                    if (value == null) continue;
                    value = value.get((Object)key);
                }
                rowFormatted[columnID] = value != null ? DataTableServices.format(value, row, column) : "";
            } else {
                rowFormatted[columnID] = DataTableServices.format(null, row, column);
            }
            ++columnID;
        }
        return rowFormatted;
    }

    @GET
    @Path(value="/exports/{id}")
    @Produces(value={"application/json"})
    @Secured
    public ExportTaskManager.ExportStatus getExport(@PathParam(value="id") String reportID) throws Exception {
        return this.exportTaskManager.getExportStatus(reportID);
    }

    public static Field getField(String fieldName, Class<?> type) {
        try {
            return type.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (type.getSuperclass() != null) {
                return DataTableServices.getField(fieldName, type.getSuperclass());
            }
            return null;
        }
        catch (SecurityException e) {
            throw e;
        }
    }

    private static String format(Object value, Document row, ColumnDef column) {
        return column.format.format(value, row);
    }

    public static class ExportTask
    extends ExportTaskManager.ExportRunnable {
        protected BackendDataTable table;
        protected Bson query;
        protected SearchOrder order;

        public ExportTask(BackendDataTable table, Bson query, SearchOrder order) {
            this.table = table;
            this.query = query;
            this.order = order;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runExport() throws Exception {
            try {
                CollectionFind find = this.table.getCollection().find(this.query, this.order, null, null);
                try (PrintWriter writer = new PrintWriter(new File(this.getContainer() + "/export.csv"), "UTF-8");){
                    List<ColumnDef> columns = this.table.getExportColumns() != null ? this.table.getExportColumns() : this.table.getColumns();
                    for (ColumnDef colDef : columns) {
                        String title = colDef.title.replaceAll("^ID", "id");
                        writer.print(title);
                        writer.print(DataTableServices.CSV_DELIMITER);
                    }
                    writer.println();
                    find.getRecordsFiltered();
                    Iterator it = find.getIterator();
                    int count = 0;
                    while (it.hasNext()) {
                        String[] formattedRow;
                        ++count;
                        Document object = (Document)it.next();
                        for (String val : formattedRow = DataTableServices.formatRow(columns, object)) {
                            if (val.contains(DataTableServices.CSV_DELIMITER) || val.contains("\n") || val.contains("\"")) {
                                val = "\"" + val.replaceAll("\"", "\"\"") + "\"";
                            }
                            writer.print(val);
                            writer.print(DataTableServices.CSV_DELIMITER);
                        }
                        writer.println();
                    }
                }
            }
            catch (Exception e) {
                logger.error("An error occurred while generating report", (Throwable)e);
            }
        }
    }
}

