/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.threadmanager;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import step.common.managedoperations.Operation;
import step.common.managedoperations.OperationManager;
import step.core.GlobalContext;
import step.core.execution.ExecutionContext;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.plugins.threadmanager.ThreadManagerServices;

@Plugin
public class ThreadManager
extends AbstractPlugin {
    private List<Pattern> matchingPatterns = new ArrayList<Pattern>();
    public static final String THREAD_MANAGER_INSTANCE_KEY = "ThreadManagerPlugin_Instance";
    private static final String SET_KEY = "ThreadManagerPlugin_SetKey";

    private void registerPattern(Pattern pattern) {
        this.matchingPatterns.add(pattern);
    }

    private void registerClass(Class<?> clazz) {
        this.matchingPatterns.add(Pattern.compile(clazz.getName().replace(".", "\\.") + ".*"));
    }

    private boolean matches(StackTraceElement[] stacktrace) {
        for (Pattern p : this.matchingPatterns) {
            Matcher m = p.matcher("");
            for (StackTraceElement el : stacktrace) {
                m.reset(el.getClassName() + "." + el.getMethodName());
                if (!m.matches()) continue;
                return true;
            }
        }
        return false;
    }

    public void executionControllerStart(GlobalContext context) {
        context.getServiceRegistrationCallback().registerService(ThreadManagerServices.class);
        context.put(THREAD_MANAGER_INSTANCE_KEY, (Object)this);
    }

    private HashSet<Thread> getRegister(ExecutionContext context) {
        return (HashSet)context.get((Object)SET_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateThread(ExecutionContext context, Thread thread) {
        HashSet<Thread> associatedThreads = this.getRegister(context);
        Object object = context;
        synchronized (object) {
            if (associatedThreads == null) {
                associatedThreads = new HashSet();
                context.put(SET_KEY, associatedThreads);
            }
        }
        object = associatedThreads;
        synchronized (object) {
            associatedThreads.add(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unassociateThread(ExecutionContext context, Thread thread) {
        HashSet<Thread> associatedThreads;
        HashSet<Thread> hashSet = associatedThreads = this.getRegister(context);
        synchronized (hashSet) {
            associatedThreads.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeExecutionEnd(ExecutionContext context) {
        HashSet<Thread> associatedThreads;
        HashSet<Thread> hashSet = associatedThreads = this.getRegister(context);
        synchronized (hashSet) {
            for (Thread thread : associatedThreads) {
                if (!this.matches(thread.getStackTrace())) continue;
                thread.interrupt();
            }
        }
    }

    public List<Operation> getCurrentOperations(ExecutionContext context) {
        HashSet<Thread> associatedThreads = this.getRegister(context);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        if (associatedThreads != null) {
            for (Thread thread : associatedThreads) {
                operations.add(OperationManager.getInstance().getOperation(Long.valueOf(thread.getId())));
            }
        }
        return operations;
    }
}

