/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.events;

import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import step.core.deployment.AbstractServices;
import step.plugins.events.Event;
import step.plugins.events.EventBroker;

@Singleton
@Path(value="/eventbroker")
public class EventBrokerServices
extends AbstractServices {
    private EventBroker eb;

    @PostConstruct
    public void init() {
        this.eb = (EventBroker)this.getContext().get(EventBroker.class);
    }

    @GET
    @Path(value="/events")
    public String getEventBrokerStatus() {
        return this.eb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/event")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Event putEvent(Event event) {
        if (event != null) {
            event.setSubmitionTimestamp(System.currentTimeMillis());
        }
        Event ret = null;
        EventBroker eventBroker = this.eb;
        synchronized (eventBroker) {
            ret = this.eb.put(event);
        }
        return ret;
    }

    @GET
    @Path(value="/event/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Event peekEvent(@PathParam(value="id") String id) {
        Event event = this.eb.get(id);
        if (event != null) {
            event.setLastReadTimestamp(System.currentTimeMillis());
        }
        return event;
    }

    @GET
    @Path(value="/event/group/{group}/name/{name}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Event peekEventByGroupAndName(@PathParam(value="group") String group, @PathParam(value="name") String name) {
        Event event = this.eb.get(group, name);
        if (event != null) {
            event.setLastReadTimestamp(System.currentTimeMillis());
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/event/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Event consumeEvent(@PathParam(value="id") String id) {
        Event ret = this.eb.get(id);
        if (ret != null) {
            ret.setDeletionTimestamp(System.currentTimeMillis());
        }
        EventBroker eventBroker = this.eb;
        synchronized (eventBroker) {
            this.eb.remove(id);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/event/group/{group}/name/{name}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Event consumeEventByGroupAndName(@PathParam(value="group") String group, @PathParam(value="name") String name) {
        Event ret = null;
        EventBroker eventBroker = this.eb;
        synchronized (eventBroker) {
            ret = this.eb.get(group, name);
            if (ret != null) {
                this.eb.remove(ret.getId());
            }
        }
        if (ret != null) {
            ret.setDeletionTimestamp(System.currentTimeMillis());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/events")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String clear() {
        EventBroker eventBroker = this.eb;
        synchronized (eventBroker) {
            this.eb.clear();
        }
        return "{ \"status\" : \"success\"}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/events/group/{group}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String clearGroup(@PathParam(value="group") String group) {
        EventBroker eventBroker = this.eb;
        synchronized (eventBroker) {
            this.eb.clearGroup(group);
        }
        return "{ \"status\" : \"success\"}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/magicevent")
    @Produces(value={"application/json"})
    public Event magicPutEvent() {
        EventBroker eventBroker = this.eb;
        synchronized (eventBroker) {
            return this.putEvent(new Event().setId(UUID.randomUUID().toString()).setName("hello").setGroup("testGroup"));
        }
    }
}

