/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.screentemplating;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import step.commons.activation.Activator;
import step.commons.conf.Configuration;
import step.commons.conf.FileRepository;
import step.commons.helpers.FileHelper;
import step.core.GlobalContext;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.plugins.screentemplating.Input;
import step.plugins.screentemplating.Option;
import step.plugins.screentemplating.ScreenTemplateService;

@Plugin
public class ScreenTemplatePlugin
extends AbstractPlugin {
    public static final String SCREEN_TEMPLATE_KEY = "ScreenTemplatePlugin_Instance";
    FileRepository<Map<String, List<Input>>> repo;
    Map<String, List<Input>> screenTemplates;

    public void executionControllerStart(GlobalContext context) {
        File file;
        String config = Configuration.getInstance().getProperty("screentemplate.config");
        if (config == null && (file = FileHelper.getClassLoaderResource(((Object)((Object)this)).getClass(), (String)"ScreenTemplates.js")) != null) {
            config = file.getAbsolutePath();
        }
        if (config != null) {
            this.repo = new FileRepository(new File(config), (TypeReference)new TypeReference<Map<String, List<Input>>>(){}, (FileRepository.FileRepositoryCallback)new FileRepository.FileRepositoryCallback<Map<String, List<Input>>>(){

                public void onLoad(Map<String, List<Input>> screens) throws ScriptException {
                    for (String screenId : screens.keySet()) {
                        List<Input> inputs = screens.get(screenId);
                        Activator.compileActivationExpressions(inputs);
                        for (Input input : inputs) {
                            if (input.getOptions() == null) continue;
                            Activator.compileActivationExpressions(input.getOptions());
                        }
                    }
                    ScreenTemplatePlugin.this.screenTemplates = screens;
                }
            });
            context.put(SCREEN_TEMPLATE_KEY, (Object)this);
            context.getServiceRegistrationCallback().registerService(ScreenTemplateService.class);
        }
    }

    public List<Input> getInputsForScreen(String screenId, Map<String, Object> contextBindings) {
        this.assertInitialized();
        ArrayList<Input> result = new ArrayList<Input>();
        List inputs = Activator.findAllMatches(contextBindings, this.screenTemplates.get(screenId));
        for (Input input : inputs) {
            List<Option> options = input.getOptions();
            List activeOptions = null;
            if (options != null) {
                activeOptions = Activator.findAllMatches(contextBindings, options);
            }
            result.add(new Input(input.getType(), input.getId(), input.getLabel(), activeOptions));
        }
        return result;
    }

    private void assertInitialized() {
        if (this.screenTemplates == null) {
            throw new RuntimeException("Service not initialized");
        }
    }
}

