/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.datatable;

import com.mongodb.client.model.Filters;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.bson.conversions.Bson;
import step.plugins.datatable.SearchQueryFactory;

public class DateRangeCriterium
implements SearchQueryFactory {
    private SimpleDateFormat DATE_FORMAT;

    public DateRangeCriterium(String dateFormat) {
        this.DATE_FORMAT = new SimpleDateFormat(dateFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bson createQuery(String attributeName, String expression) {
        try {
            Date from;
            SimpleDateFormat simpleDateFormat = this.DATE_FORMAT;
            synchronized (simpleDateFormat) {
                from = this.DATE_FORMAT.parse(expression);
            }
            Calendar c = Calendar.getInstance();
            c.setTime(from);
            c.add(5, 1);
            Date to = c.getTime();
            return Filters.and((Bson[])new Bson[]{Filters.lt((String)attributeName, (Object)to.getTime()), Filters.gte((String)attributeName, (Object)from.getTime())});
        }
        catch (ParseException e) {
            return null;
        }
    }
}

