/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.datatable;

import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.accessors.Collection;
import step.core.accessors.CollectionFind;
import step.core.accessors.CollectionRegistry;
import step.core.accessors.SearchOrder;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.export.ExportTaskManager;
import step.core.ql.OQLMongoDBBuilder;
import step.plugins.datatable.BackendDataTableDataResponse;

@Singleton
@Path(value="table")
public class TableService
extends AbstractServices {
    private static final Logger logger = LoggerFactory.getLogger(TableService.class);
    protected CollectionRegistry collectionRegistry;
    protected ExportTaskManager exportTaskManager;
    ExecutorService reportExecutor = Executors.newFixedThreadPool(2);
    protected MongoDatabase database;
    Pattern columnSearchPattern = Pattern.compile("columns\\[([0-9]+)\\]\\[search\\]\\[value\\]");
    Pattern searchPattern = Pattern.compile("search\\[value\\]");
    Pattern namePattern = Pattern.compile("columns\\[([0-9]+)\\]\\[name\\]");

    @PostConstruct
    public void init() {
        this.database = this.getContext().getMongoClientSession().getMongoDatabase();
        this.collectionRegistry = (CollectionRegistry)this.getContext().get(CollectionRegistry.class);
    }

    @PreDestroy
    public void destroy() {
    }

    @POST
    @Path(value="/{id}/data")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Secured
    public BackendDataTableDataResponse getTableData_Post(@PathParam(value="id") String collectionID, MultivaluedMap<String, String> form, @Context UriInfo uriInfo) throws Exception {
        if (uriInfo.getQueryParameters() != null) {
            form.putAll((Map)uriInfo.getQueryParameters());
        }
        return this.getTableData(collectionID, form);
    }

    @GET
    @Path(value="/{id}/data")
    @Produces(value={"application/json"})
    @Secured
    public BackendDataTableDataResponse getTableData_Get(@PathParam(value="id") String collectionID, @Context UriInfo uriInfo) throws Exception {
        return this.getTableData(collectionID, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
    }

    private BackendDataTableDataResponse getTableData(@PathParam(value="id") String collectionID, MultivaluedMap<String, String> params) throws Exception {
        Collection collection = this.collectionRegistry.get(collectionID);
        if (collection == null) {
            collection = new Collection(this.database, collectionID);
        }
        Map<Integer, String> columnNames = this.getColumnNamesMap(params);
        List<Bson> queryFragments = this.createQueryFragments(params, columnNames);
        int draw = Integer.parseInt((String)params.getFirst((Object)"draw"));
        int skip = Integer.parseInt((String)params.getFirst((Object)"start"));
        int limit = Integer.parseInt((String)params.getFirst((Object)"length"));
        int sortColumnID = Integer.parseInt((String)params.getFirst((Object)"order[0][column]"));
        String sortColumnName = columnNames.get(sortColumnID);
        String sortDir = (String)params.getFirst((Object)"order[0][dir]");
        SearchOrder order = new SearchOrder(sortColumnName, sortDir.equals("asc") ? 1 : -1);
        Bson query = queryFragments.size() > 0 ? Filters.and(queryFragments) : new Document();
        CollectionFind find = collection.find(query, order, Integer.valueOf(skip), Integer.valueOf(limit));
        Iterator it = find.getIterator();
        ArrayList objects = new ArrayList();
        while (it.hasNext()) {
            objects.add(it.next());
        }
        String[][] data = new String[objects.size()][1];
        for (int i = 0; i < objects.size(); ++i) {
            Document row = (Document)objects.get(i);
            String[] rowFormatted = new String[columnNames.size()];
            rowFormatted[0] = row.toJson();
            data[i] = rowFormatted;
        }
        BackendDataTableDataResponse response = new BackendDataTableDataResponse(draw, find.getRecordsTotal(), find.getRecordsFiltered(), data);
        return response;
    }

    private List<Bson> createQueryFragments(MultivaluedMap<String, String> params, Map<Integer, String> columnNames) {
        ArrayList<Bson> queryFragments = new ArrayList<Bson>();
        for (String key : params.keySet()) {
            String searchValue;
            Matcher m = this.columnSearchPattern.matcher(key);
            Matcher searchMatcher = this.searchPattern.matcher(key);
            if (m.matches()) {
                int columnID = Integer.parseInt(m.group(1));
                String columnName = columnNames.get(columnID);
                String searchValue2 = (String)params.getFirst((Object)key);
                if (searchValue2 == null || searchValue2.length() <= 0) continue;
                queryFragments.add(Filters.regex((String)columnName, (String)searchValue2));
                continue;
            }
            if (searchMatcher.matches() && (searchValue = (String)params.getFirst((Object)key)) != null && searchValue.length() <= 0) continue;
        }
        if (params.containsKey((Object)"filter")) {
            Bson filter = OQLMongoDBBuilder.build((String)((String)params.getFirst((Object)"filter")));
            queryFragments.add(filter);
        }
        return queryFragments;
    }

    private Map<Integer, String> getColumnNamesMap(MultivaluedMap<String, String> params) {
        HashMap<Integer, String> columnNames = new HashMap<Integer, String>();
        for (String key : params.keySet()) {
            Matcher m = this.namePattern.matcher(key);
            if (!m.matches()) continue;
            int columnID = Integer.parseInt(m.group(1));
            String columnName = (String)params.getFirst((Object)key);
            columnNames.put(columnID, columnName);
        }
        return columnNames;
    }
}

