/*
 * Decompiled with CFR 0.152.
 */
package ch.exense.commons.app;

import com.google.common.base.Predicate;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class ClasspathUtils {
    public static <T> Set<Class> getAllSubTypesOf(Class clazz, String prefix) {
        Reflections reflections = ClasspathUtils.getReflections(clazz, prefix);
        HashSet<Class> fullTree = new HashSet<Class>();
        Set thisNode = reflections.getSubTypesOf(clazz);
        fullTree.addAll(thisNode);
        for (Class subType : thisNode) {
            fullTree.addAll(ClasspathUtils.getAllSubTypesOf(subType, prefix));
        }
        return fullTree;
    }

    public static <T> Set<Class> getAllConcreteSubTypesOf(Class clazz, String prefix) {
        return ClasspathUtils.getAllSubTypesOf(clazz, prefix).stream().filter(c -> !Modifier.isAbstract(c.getModifiers())).collect(Collectors.toSet());
    }

    private static <T> Reflections getReflections(Class<T> clazz, String prefix) {
        Collection urls = ClasspathHelper.forPackage((String)prefix, (ClassLoader[])new ClassLoader[0]);
        FilterBuilder filterBuilder = new FilterBuilder().includePackage(new String[]{"ch.exense"});
        if (prefix != "ch.exense") {
            urls.addAll(ClasspathHelper.forPackage((String)"ch.exense", (ClassLoader[])new ClassLoader[0]));
            filterBuilder.includePackage(new String[]{prefix});
        }
        return new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)filterBuilder).setUrls(urls).setScanners(new Scanner[]{new SubTypesScanner()}));
    }

    public static <T> Set<Class<? extends T>> getSubTypesOf(Class<T> clazz, String prefix) {
        Reflections reflections = ClasspathUtils.getReflections(clazz, prefix);
        return reflections.getSubTypesOf(clazz);
    }

    public static <T> Collection<Class<? extends Object>> getChildrenClassListFromClasspath(Class<T> clazz) {
        ServiceLoader<T> loader = ServiceLoader.load(clazz);
        ArrayList<Class<? extends Object>> classList = new ArrayList<Class<? extends Object>>();
        for (T serv : loader) {
            classList.add(serv.getClass());
        }
        return classList;
    }
}

