/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.netcode;

import ch.awae.netcode.Channel;
import ch.awae.netcode.ChannelConfiguration;
import ch.awae.netcode.ChannelInformation;
import ch.awae.netcode.ChannelManager;
import ch.awae.netcode.ConnectionException;
import ch.awae.netcode.InvalidAppIdException;
import ch.awae.netcode.InvalidChannelIdException;
import ch.awae.netcode.InvalidRequestException;
import ch.awae.netcode.Message;
import ch.awae.netcode.MessageFactory;
import ch.awae.netcode.NetcodeHandshakeRequest;
import ch.awae.netcode.Parser;
import ch.awae.netcode.SSMessageImpl;
import ch.awae.netcode.ServerCapabilities;
import ch.awae.netcode.ServerCommand;
import ch.awae.netcode.ServerCommandResponse;
import ch.awae.netcode.UnsupportedFeatureException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;

final class ClientHandler
extends Thread {
    private final Socket socket;
    private final ChannelManager manager;
    private final BufferedReader in;
    private final PrintWriter out;
    private final ServerCapabilities features;
    private String userId;
    private Channel channel;
    private String appId;

    ClientHandler(ChannelManager manager, Socket socket, ServerCapabilities features) throws IOException {
        this.manager = manager;
        this.socket = socket;
        this.features = features;
        try {
            this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.out = new PrintWriter(socket.getOutputStream());
        }
        catch (IOException e) {
            socket.close();
            throw e;
        }
    }

    @Override
    public void run() {
        try {
            this.channel = this.performHandshake();
            try {
                this.runLoop();
            }
            finally {
                if (this.channel != null) {
                    this.channel.quit(this.userId);
                }
            }
        }
        catch (Exception e) {
            try {
                this.out.println(Parser.pojo2json(MessageFactory.serverMessage(e)));
                this.out.flush();
                this.socket.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    private void runLoop() throws IOException {
        String l;
        while (!Thread.interrupted() && (l = this.in.readLine()) != null) {
            SSMessageImpl msg = Parser.json2pojo(l, SSMessageImpl.class);
            if (Thread.interrupted()) break;
            if (!msg.isManagementMessage()) {
                this.channel.send(msg);
                continue;
            }
            if (!(msg.getPayload() instanceof ServerCommand)) continue;
            ServerCommand command = (ServerCommand)msg.getPayload();
            try {
                Serializable data = this.processServerCommand(command.getVerb(), command.getData());
                this.out.println(Parser.pojo2json(MessageFactory.serverMessage(new ServerCommandResponse(command.getCommandId(), data))));
                this.out.flush();
            }
            catch (Exception e) {
                this.out.println(Parser.pojo2json(MessageFactory.serverMessage(new ServerCommandResponse(command.getCommandId(), e))));
                this.out.flush();
            }
        }
    }

    private Serializable processServerCommand(String verb, Serializable data) throws UnsupportedFeatureException, InvalidAppIdException, InvalidRequestException {
        if (!this.features.isEnableServerCommands()) {
            throw new UnsupportedFeatureException("server commands are disabled on this server");
        }
        if (verb == null) {
            throw new InvalidRequestException("unknown command: " + verb);
        }
        switch (verb) {
            case "get_channel_info": {
                return this.channel.getInfo();
            }
            case "get_channel_list": {
                if (!this.features.isEnablePublicChannels()) {
                    throw new UnsupportedFeatureException("public channels are disabled on this server");
                }
                return this.manager.getPublicChannels(this.appId).toArray(new ChannelInformation[0]);
            }
        }
        throw new InvalidRequestException("unknown command: " + verb);
    }

    void send(Message msg) throws IOException {
        this.out.println(Parser.pojo2json(msg));
        this.out.flush();
    }

    private Channel performHandshake() throws IOException, ConnectionException, InterruptedException {
        Channel channel;
        this.out.println(this.features.getFeaturesString("NETCODE_1,SIMPLE_QUERY"));
        this.out.flush();
        NetcodeHandshakeRequest request = Parser.json2pojo(this.in.readLine(), NetcodeHandshakeRequest.class);
        if (!request.isMaster() && request.getAppId() == null && request.getChannelId() == null && request.getUserId() == null && request.getConfig() == null) {
            this.processSimpleRequest();
            this.interrupt();
            return null;
        }
        this.validate(request);
        this.userId = request.getUserId();
        this.appId = request.getAppId();
        Channel channel2 = channel = request.isMaster() ? this.manager.createChannel(request.getAppId(), request.getConfig(), request.getUserId()) : this.manager.getChannel(request.getAppId(), request.getChannelId());
        if (channel == null) {
            throw new InvalidChannelIdException("unknown channel id: '" + request.getChannelId() + "'");
        }
        channel.join(request.getUserId(), this);
        return channel;
    }

    private void processSimpleRequest() throws IOException, InvalidAppIdException, UnsupportedFeatureException, InvalidRequestException {
        String request = this.in.readLine();
        if (request.startsWith("channel_list:")) {
            if (!this.features.isEnablePublicChannels()) {
                throw new UnsupportedFeatureException("public channels are disabled on this server");
            }
        } else {
            throw new InvalidRequestException("unsupported simple query: " + request);
        }
        String appId = request.substring(13);
        this.out.println(Parser.pojo2json(MessageFactory.serverMessage((Serializable)this.manager.getPublicChannels(appId).toArray(new ChannelInformation[0]))));
        this.out.flush();
    }

    private void validate(NetcodeHandshakeRequest request) throws InvalidRequestException, InvalidAppIdException {
        if (request.getUserId() == null) {
            throw new InvalidRequestException("invalid request: userId may not be null");
        }
        if (request.getAppId() == null) {
            throw new InvalidRequestException("invalid request: appId may not be null");
        }
        if (!request.getAppId().matches("[a-zA-Z0-9_]+")) {
            throw new InvalidAppIdException("app id must be of the pattern [a-zA-Z0-9_]+");
        }
        if (request.isMaster() && request.getChannelId() != null) {
            throw new InvalidRequestException("invalid request: requested channel creation but sent along a channel id");
        }
        if (!request.isMaster() && request.getChannelId() == null) {
            throw new InvalidRequestException("invalid request: requested channel joining but missing channel id");
        }
        if (request.isMaster() && request.getConfig() == null) {
            throw new InvalidRequestException("invalid request: channel configuration missing");
        }
        if (!request.isMaster()) {
            return;
        }
        ChannelConfiguration config = request.getConfig();
        if (config.getMaxClients() < 2) {
            throw new InvalidRequestException("invalid request: at least 2 clients must be allowed");
        }
        if (config.isPublicChannel() && !this.features.isEnablePublicChannels()) {
            throw new InvalidRequestException("invalid request: public channels are disabled on this server");
        }
    }

    public void close() throws IOException {
        this.interrupt();
        this.socket.close();
    }

    public String getUserId() {
        return this.userId;
    }
}

