/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.netcode;

import ch.awae.netcode.ChannelConfiguration;
import ch.awae.netcode.ChannelEventHandler;
import ch.awae.netcode.ChannelInformation;
import ch.awae.netcode.ClientAnswer;
import ch.awae.netcode.ClientQuestion;
import ch.awae.netcode.ClientQuestionHandler;
import ch.awae.netcode.ConnectionException;
import ch.awae.netcode.GreetingMessage;
import ch.awae.netcode.IncompatibleServerException;
import ch.awae.netcode.Message;
import ch.awae.netcode.MessageFactory;
import ch.awae.netcode.MessageHandler;
import ch.awae.netcode.MessageImpl;
import ch.awae.netcode.NetcodeClient;
import ch.awae.netcode.NetcodeHandshakeRequest;
import ch.awae.netcode.Parser;
import ch.awae.netcode.PromiseManager;
import ch.awae.netcode.ServerCommand;
import ch.awae.netcode.ServerCommandResponse;
import ch.awae.netcode.UnsupportedFeatureException;
import ch.awae.netcode.UserChange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;

final class NetcodeClientImpl
extends Thread
implements NetcodeClient {
    private final Socket socket;
    private final BufferedReader in;
    private final PrintWriter out;
    private final List<String> users = new ArrayList<String>();
    private String userId;
    private ChannelConfiguration config;
    private boolean supportsPC = false;
    private boolean supportsSC = false;
    private final Object HANDLER_LOCK = new Object();
    private final BlockingQueue<MessageImpl> backlog = new LinkedBlockingQueue<MessageImpl>();
    private MessageHandler messageHandler;
    private ChannelEventHandler eventHandler;
    private ClientQuestionHandler questionHandler;
    private final PromiseManager promises;

    NetcodeClientImpl(Socket s, MessageHandler messageHandler, ChannelEventHandler eventHandler, ClientQuestionHandler questionHandler, long timeout) throws IOException {
        this.messageHandler = messageHandler;
        this.eventHandler = eventHandler;
        this.questionHandler = questionHandler;
        this.promises = new PromiseManager(timeout);
        try {
            this.socket = s;
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out = new PrintWriter(this.socket.getOutputStream());
        }
        catch (IOException e) {
            s.close();
            throw e;
        }
    }

    public void open(NetcodeHandshakeRequest request) throws IOException, ConnectionException {
        try {
            String line = this.in.readLine();
            this.processServerVersionInfo(line);
            if (!this.supportsPC && request.getConfig().isPublicChannel()) {
                throw new UnsupportedFeatureException("public channels not supported by server");
            }
            this.out.println(Parser.pojo2json(request));
            this.out.flush();
            this.userId = request.getUserId();
            while (true) {
                MessageImpl msg;
                if ((msg = Parser.json2pojo(this.in.readLine(), MessageImpl.class)).isManagementMessage() && msg.getPayload() instanceof GreetingMessage) {
                    GreetingMessage gm = (GreetingMessage)msg.getPayload();
                    this.config = gm.getConfig();
                    for (String user : gm.getUsers()) {
                        this.users.add(user);
                    }
                    break;
                }
                if (msg.isManagementMessage() && msg.getPayload() instanceof Throwable) {
                    if (msg.getPayload() instanceof ConnectionException) {
                        throw (ConnectionException)msg.getPayload();
                    }
                    throw new RuntimeException((Throwable)msg.getPayload());
                }
                if (msg.isManagementMessage()) {
                    this.handleManagementMessage(msg);
                    continue;
                }
                if (msg.getPayload() instanceof ClientQuestion) {
                    this.handleQuestion(msg);
                    continue;
                }
                this.backlog.add(msg);
            }
            if (this.messageHandler != null) {
                this.setMessageHandler(this.messageHandler);
            }
            this.start();
        }
        catch (IOException e) {
            this.socket.close();
            throw e;
        }
    }

    private void processServerVersionInfo(String line) throws IncompatibleServerException {
        List<String> versions = Arrays.asList(line.split(","));
        if (!versions.contains("NETCODE_1")) {
            throw new IncompatibleServerException("incompatible server version: expected 'NETCODE_1,SIMPLE_QUERY' but received '" + line + "'");
        }
        if (versions.contains("PUBLIC_CHANNELS")) {
            this.supportsPC = true;
        }
        if (versions.contains("SERVER_COMMANDS")) {
            this.supportsSC = true;
        }
    }

    private void handleManagementMessage(MessageImpl msg) {
        try {
            Serializable payload = msg.getPayload();
            ChannelEventHandler eventHandler = this.eventHandler;
            if (payload instanceof UserChange) {
                UserChange data = (UserChange)payload;
                if (data.isJoined()) {
                    if (!this.users.contains(data.getUserId())) {
                        this.users.add(data.getUserId());
                    }
                    if (eventHandler != null) {
                        eventHandler.clientJoined(data.getUserId());
                    }
                } else {
                    this.users.remove(data.getUserId());
                    if (eventHandler != null) {
                        eventHandler.clientLeft(data.getUserId());
                    }
                }
            } else if (payload instanceof ServerCommandResponse) {
                this.handleResponseToSC((ServerCommandResponse)payload);
            }
        }
        catch (Exception e) {
            System.err.println("an error occured while processing event: " + msg);
            e.printStackTrace();
        }
    }

    private void handleResponseToSC(ServerCommandResponse payload) {
        this.promises.fulfill(payload.getCommandId(), payload.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(MessageImpl m) {
        if (m.isManagementMessage()) {
            this.handleManagementMessage(m);
        } else {
            Object object = this.HANDLER_LOCK;
            synchronized (object) {
                if (m.getPayload() instanceof ClientQuestion) {
                    this.handleQuestion(m);
                }
                if (m.getPayload() instanceof ClientAnswer) {
                    this.handleAnswer(m);
                }
                if (this.messageHandler != null) {
                    this.handleMessage(m);
                } else {
                    this.backlog.add(m);
                }
            }
        }
    }

    private void handleAnswer(MessageImpl m) {
        ClientAnswer answer = (ClientAnswer)m.getPayload();
        this.promises.fulfill(answer.getQuestionId(), answer.getData());
    }

    private void handleMessage(MessageImpl m) {
        try {
            if (m.getPayload() instanceof ClientQuestion) {
                this.handleQuestion(m);
            }
            if (m.getPayload() instanceof ClientAnswer) {
                this.handleAnswer(m);
            } else if (m.isPrivateMessage()) {
                this.messageHandler.handlePrivateMessage(m, m.getUserId());
            } else {
                this.messageHandler.handleMessage(m);
            }
        }
        catch (Exception e) {
            System.err.println("an error occured while processing a message: " + m);
            e.printStackTrace();
        }
    }

    private void handleQuestion(MessageImpl m) {
        ClientQuestion q = (ClientQuestion)m.getPayload();
        String from = m.getUserId();
        Serializable payload = null;
        try {
            ClientQuestionHandler cqh = this.questionHandler;
            if (cqh == null) {
                throw new UnsupportedOperationException("no question handler defined");
            }
            payload = cqh.handleQuestion(from, q.getData());
        }
        catch (Exception e) {
            payload = e;
        }
        this.out.println(Parser.pojo2json(MessageFactory.privateMessage(this.userId, from, q.response(payload))));
        this.out.flush();
    }

    @Override
    public ChannelConfiguration getChannelConfiguration() {
        return this.config;
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                try {
                    String m = this.in.readLine();
                    if (m == null) continue;
                    MessageImpl msg = Parser.json2pojo(m, MessageImpl.class);
                    this.process(msg);
                }
                catch (IOException e) {
                    // empty catch block
                    break;
                }
            }
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void disconnect() throws IOException {
        this.socket.close();
    }

    @Override
    public void send(Serializable payload) {
        this.out.println(Parser.pojo2json(MessageFactory.normalMessage(this.userId, payload)));
        this.out.flush();
    }

    @Override
    public String[] getUsers() {
        return this.users.toArray(new String[0]);
    }

    @Override
    public void sendPrivately(String userId, Serializable payload) {
        Objects.requireNonNull(userId);
        if (!this.users.contains(userId)) {
            throw new IllegalArgumentException("unknown client: " + userId);
        }
        this.out.println(Parser.pojo2json(MessageFactory.privateMessage(this.userId, userId, payload)));
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMessageHandler(MessageHandler handler) {
        Object object = this.HANDLER_LOCK;
        synchronized (object) {
            this.messageHandler = handler;
            if (this.messageHandler != null) {
                while (!this.backlog.isEmpty()) {
                    this.handleMessage((MessageImpl)this.backlog.poll());
                }
            }
        }
    }

    @Override
    public Message receive() throws InterruptedException {
        return this.backlog.take();
    }

    @Override
    public Message tryReceive() {
        return (Message)this.backlog.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object simpleQuery(String string) throws IOException, ConnectionException {
        try {
            String line = this.in.readLine();
            List<String> versions = Arrays.asList(line.split(","));
            if (!versions.contains("SIMPLE_QUERY")) {
                throw new UnsupportedFeatureException("simple queries not supported by server");
            }
            this.out.println(Parser.pojo2json(new NetcodeHandshakeRequest(null, null, null, false, null)));
            this.out.println(string);
            this.out.flush();
            MessageImpl msg = Parser.json2pojo(this.in.readLine(), MessageImpl.class);
            if (msg.getPayload() instanceof Throwable) {
                if (msg.getPayload() instanceof ConnectionException) {
                    throw (ConnectionException)msg.getPayload();
                }
                throw new RuntimeException((Throwable)msg.getPayload());
            }
            Serializable serializable = msg.getPayload();
            return serializable;
        }
        finally {
            this.socket.close();
        }
    }

    private Serializable runServerCommand(String verb, Serializable data) throws InterruptedException, ConnectionException, TimeoutException {
        if (!this.supportsSC) {
            throw new UnsupportedFeatureException("server commands not supported by server");
        }
        return this.promises.create(id -> {
            MessageImpl message = MessageFactory.serverMessage(new ServerCommand(id, verb, data));
            this.out.println(Parser.pojo2json(message));
            this.out.flush();
        });
    }

    @Override
    public Serializable ask(String userId, Serializable data) throws InterruptedException, TimeoutException {
        try {
            return this.promises.create(id -> this.sendPrivately(userId, new ClientQuestion(id, data)));
        }
        catch (ConnectionException ce) {
            throw new RuntimeException(ce);
        }
    }

    @Override
    public ChannelInformation[] getPublicChannels() throws InterruptedException, ConnectionException, TimeoutException {
        return (ChannelInformation[])this.runServerCommand("get_channel_list", null);
    }

    @Override
    public ChannelInformation getChannelInformation() throws InterruptedException, ConnectionException, TimeoutException {
        return (ChannelInformation)this.runServerCommand("get_channel_info", null);
    }

    @Override
    public void setTimeout(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout may not be negative!");
        }
        this.promises.setTimeout(millis);
    }

    @Override
    public long getTimeout() {
        return this.promises.getTimeout();
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    @Override
    public ChannelEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public void setEventHandler(ChannelEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public ClientQuestionHandler getQuestionHandler() {
        return this.questionHandler;
    }

    @Override
    public void setQuestionHandler(ClientQuestionHandler questionHandler) {
        this.questionHandler = questionHandler;
    }
}

