/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.netcode;

import ch.awae.netcode.Channel;
import ch.awae.netcode.ChannelConfiguration;
import ch.awae.netcode.ChannelManager;
import ch.awae.netcode.ConnectionException;
import ch.awae.netcode.InvalidChannelIdException;
import ch.awae.netcode.InvalidRequestException;
import ch.awae.netcode.Message;
import ch.awae.netcode.MessageFactory;
import ch.awae.netcode.MessageImpl;
import ch.awae.netcode.NetcodeHandshakeRequest;
import ch.awae.netcode.Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

final class ClientHandler
extends Thread {
    private final Socket socket;
    private final ChannelManager manager;
    private final BufferedReader in;
    private final PrintWriter out;
    private Channel channel;
    private String userId;

    ClientHandler(ChannelManager manager, Socket socket) throws IOException {
        this.manager = manager;
        this.socket = socket;
        try {
            this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.out = new PrintWriter(socket.getOutputStream());
        }
        catch (IOException e) {
            socket.close();
            throw e;
        }
    }

    @Override
    public void run() {
        try {
            this.channel = this.performHandshake();
            try {
                this.runLoop();
            }
            finally {
                this.channel.quit(this.userId);
            }
        }
        catch (Exception e) {
            try {
                this.out.println(Parser.pojo2json(MessageFactory.serverMessage(e)));
                this.out.flush();
                this.socket.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    private void runLoop() throws IOException {
        String l;
        while (!Thread.interrupted() && (l = this.in.readLine()) != null) {
            MessageImpl msg = Parser.json2pojo(l, MessageImpl.class);
            if (Thread.interrupted()) break;
            if (msg.isManagementMessage()) continue;
            this.channel.send(msg);
        }
    }

    void send(Message msg) throws IOException {
        this.out.println(Parser.pojo2json(msg));
        this.out.flush();
    }

    private Channel performHandshake() throws IOException, ConnectionException {
        Channel channel;
        this.out.println("NETCODE_1");
        this.out.flush();
        NetcodeHandshakeRequest request = Parser.json2pojo(this.in.readLine(), NetcodeHandshakeRequest.class);
        this.validate(request);
        this.userId = request.getUserId();
        Channel channel2 = channel = request.isMaster() ? this.manager.createChannel(request.getAppId(), request.getConfig()) : this.manager.getChannel(request.getAppId(), request.getChannelId());
        if (channel == null) {
            throw new InvalidChannelIdException("unknown channel id: '" + request.getChannelId() + "'");
        }
        channel.join(request.getUserId(), this);
        return channel;
    }

    private void validate(NetcodeHandshakeRequest request) throws InvalidRequestException {
        if (request.getUserId() == null) {
            throw new InvalidRequestException("invalid request: userId may not be null");
        }
        if (request.getAppId() == null) {
            throw new InvalidRequestException("invalid request: userId may not be null");
        }
        if (request.isMaster() && request.getChannelId() != null) {
            throw new InvalidRequestException("invalid request: requested channel creation but sent along a channel id");
        }
        if (!request.isMaster() && request.getChannelId() == null) {
            throw new InvalidRequestException("invalid request: requested channel joining but missing channel id");
        }
        if (request.isMaster() && request.getConfig() == null) {
            throw new InvalidRequestException("invalid request: channel configuration missing");
        }
        if (!request.isMaster()) {
            return;
        }
        ChannelConfiguration config = request.getConfig();
        if (config.getMaxClients() < 2) {
            throw new InvalidRequestException("invalid request: at least 2 clients must be allowed");
        }
    }

    public void close() throws IOException {
        this.interrupt();
        this.socket.close();
    }

    public String getUserId() {
        return this.userId;
    }
}

