/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.netcode;

import ch.awae.netcode.ChannelConfiguration;
import ch.awae.netcode.ChannelEventHandler;
import ch.awae.netcode.ConnectionException;
import ch.awae.netcode.GreetingMessage;
import ch.awae.netcode.IncompatibleServerException;
import ch.awae.netcode.Message;
import ch.awae.netcode.MessageFactory;
import ch.awae.netcode.MessageHandler;
import ch.awae.netcode.MessageImpl;
import ch.awae.netcode.NetcodeClient;
import ch.awae.netcode.NetcodeHandshakeRequest;
import ch.awae.netcode.Parser;
import ch.awae.netcode.UserChange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

final class NetcodeClientImpl
extends Thread
implements NetcodeClient {
    private final Socket socket;
    private final BufferedReader in;
    private final PrintWriter out;
    private String userId;
    private ChannelConfiguration config;
    private MessageHandler messageHandler;
    private ChannelEventHandler eventHandler;
    private final Object WRITE_LOCK = new Object();
    private List<String> users = new ArrayList<String>();
    private BlockingQueue<MessageImpl> backlog = new LinkedBlockingQueue<MessageImpl>();

    public NetcodeClientImpl(Socket s, MessageHandler messageHandler, ChannelEventHandler eventHandler) throws IOException {
        this.messageHandler = messageHandler;
        this.eventHandler = eventHandler;
        try {
            this.socket = s;
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out = new PrintWriter(this.socket.getOutputStream());
        }
        catch (IOException e) {
            s.close();
            throw e;
        }
    }

    public void open(NetcodeHandshakeRequest request) throws IOException, ConnectionException {
        try {
            String line = this.in.readLine();
            if (!"NETCODE_1".equals(line)) {
                throw new IncompatibleServerException("incompatible server version: expected 'NETCODE_1' but received '" + line + "'");
            }
            this.out.println(Parser.pojo2json(request));
            this.out.flush();
            this.userId = request.getUserId();
            while (true) {
                MessageImpl msg;
                if ((msg = Parser.json2pojo(this.in.readLine(), MessageImpl.class)).isManagementMessage() && msg.getPayload() instanceof GreetingMessage) {
                    GreetingMessage gm = (GreetingMessage)msg.getPayload();
                    this.config = gm.getConfig();
                    for (String user : gm.getUsers()) {
                        this.users.add(user);
                    }
                    break;
                }
                if (msg.isManagementMessage() && msg.getPayload() instanceof Throwable) {
                    if (msg.getPayload() instanceof ConnectionException) {
                        throw (ConnectionException)msg.getPayload();
                    }
                    throw new RuntimeException((Throwable)msg.getPayload());
                }
                if (msg.isManagementMessage()) {
                    this.handleManagementMessage(msg);
                    continue;
                }
                this.backlog.add(msg);
            }
            if (this.messageHandler != null) {
                this.setMessageHandler(this.messageHandler);
            }
            this.start();
        }
        catch (IOException e) {
            this.socket.close();
            throw e;
        }
    }

    private void handleManagementMessage(MessageImpl msg) {
        try {
            Serializable payload = msg.getPayload();
            ChannelEventHandler eventHandler = this.eventHandler;
            if (payload instanceof UserChange) {
                UserChange data = (UserChange)payload;
                if (data.isJoined()) {
                    if (!this.users.contains(data.getUserId())) {
                        this.users.add(data.getUserId());
                    }
                    if (eventHandler != null) {
                        eventHandler.clientJoined(data.getUserId());
                    }
                } else {
                    this.users.remove(data.getUserId());
                    if (eventHandler != null) {
                        eventHandler.clientLeft(data.getUserId());
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("an error occured while processing event: " + msg);
            e.printStackTrace();
        }
    }

    private void process(MessageImpl m) {
        if (m.isManagementMessage()) {
            this.handleManagementMessage(m);
        } else if (this.messageHandler != null) {
            try {
                this.messageHandler.handleMessage(m);
            }
            catch (Exception e) {
                System.err.println("an error occured while processing a message: " + m);
                e.printStackTrace();
            }
        } else {
            this.backlog.add(m);
        }
    }

    @Override
    public ChannelConfiguration getChannelConfiguration() {
        return this.config;
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                try {
                    String m = this.in.readLine();
                    if (m == null) continue;
                    MessageImpl msg = Parser.json2pojo(m, MessageImpl.class);
                    this.process(msg);
                }
                catch (IOException e) {
                    // empty catch block
                    break;
                }
            }
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void disconnect() throws IOException {
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Serializable payload) {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.out.println(Parser.pojo2json(MessageFactory.normalMessage(this.userId, payload)));
            this.out.flush();
        }
    }

    @Override
    public String[] getUsers() {
        return this.users.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPrivately(String userId, Serializable payload) {
        Objects.requireNonNull(userId);
        if (!this.users.contains(userId)) {
            throw new IllegalArgumentException("unknown client: " + userId);
        }
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.out.println(Parser.pojo2json(MessageFactory.privateMessage(this.userId, userId, payload)));
            this.out.flush();
        }
    }

    @Override
    public void setMessageHandler(MessageHandler handler) {
        this.messageHandler = handler;
        if (this.messageHandler != null) {
            while (!this.backlog.isEmpty()) {
                MessageImpl m = (MessageImpl)this.backlog.poll();
                try {
                    this.messageHandler.handleMessage(m);
                }
                catch (Exception e) {
                    System.err.println("an error occured while processing a message: " + m);
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public Message receive() throws InterruptedException {
        return this.backlog.take();
    }

    @Override
    public Message tryReceive() {
        return (Message)this.backlog.poll();
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setEventHandler(ChannelEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }
}

