/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.netcode;

import ch.awae.netcode.ChannelConfiguration;
import ch.awae.netcode.ConnectionException;
import ch.awae.netcode.GreetingMessage;
import ch.awae.netcode.MessageFactory;
import ch.awae.netcode.MessageHandler;
import ch.awae.netcode.MessageImpl;
import ch.awae.netcode.NetcodeClient;
import ch.awae.netcode.NetcodeHandshakeRequest;
import ch.awae.netcode.Parser;
import ch.awae.netcode.UserChange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

final class NetcodeClientImpl
extends Thread
implements NetcodeClient {
    private final Socket socket;
    private final BufferedReader in;
    private final PrintWriter out;
    private String userId;
    private ChannelConfiguration config;
    private MessageHandler messageHandler;
    private final Object WRITE_LOCK = new Object();
    private List<String> users = new ArrayList<String>();
    private BlockingQueue<MessageImpl> backlog = new LinkedBlockingQueue<MessageImpl>();

    public NetcodeClientImpl(Socket s, MessageHandler messageHandler) throws IOException {
        this.messageHandler = messageHandler;
        try {
            this.socket = s;
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out = new PrintWriter(this.socket.getOutputStream());
        }
        catch (IOException e) {
            s.close();
            throw e;
        }
    }

    public void open(NetcodeHandshakeRequest request) throws IOException, ConnectionException {
        try {
            this.out.println(Parser.pojo2json(request));
            this.out.flush();
            this.userId = request.getUserId();
            while (true) {
                MessageImpl msg;
                if ((msg = Parser.json2pojo(this.in.readLine(), MessageImpl.class)).isManagementMessage() && msg.getPayload() instanceof GreetingMessage) {
                    GreetingMessage gm = (GreetingMessage)msg.getPayload();
                    this.config = gm.getConfig();
                    if (this.messageHandler == null) break;
                    for (String user : gm.getUsers()) {
                        this.messageHandler.clientJoined(user);
                    }
                    break;
                }
                if (msg.isManagementMessage() && msg.getPayload() instanceof Throwable) {
                    if (msg.getPayload() instanceof ConnectionException) {
                        throw new ConnectionException(((ConnectionException)msg.getPayload()).getMessage());
                    }
                    throw new RuntimeException((Throwable)msg.getPayload());
                }
                this.backlog.add(msg);
            }
            if (this.messageHandler != null) {
                this.setMessageHandler(this.messageHandler);
            }
            this.start();
        }
        catch (IOException e) {
            this.socket.close();
            throw e;
        }
    }

    private void process(MessageImpl m) {
        if (m.isManagementMessage() && m.getPayload() instanceof UserChange) {
            UserChange data = (UserChange)m.getPayload();
            if (data.isJoined()) {
                if (!this.users.contains(data.getUserId())) {
                    this.users.add(data.getUserId());
                }
                this.messageHandler.clientJoined(data.getUserId());
            } else {
                this.users.remove(data.getUserId());
                this.messageHandler.clientLeft(data.getUserId());
            }
        } else {
            this.messageHandler.handleMessage(m);
        }
    }

    @Override
    public ChannelConfiguration getChannelConfiguration() {
        return this.config;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP], 1[TRYBLOCK]], but top level block is 11[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void disconnect() throws IOException {
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Serializable payload) throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.out.println(Parser.pojo2json(MessageFactory.normalMessage(this.userId, payload)));
            this.out.flush();
        }
    }

    @Override
    public String[] getUsers() {
        return this.users.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPrivately(String userId, Serializable payload) throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.out.println(Parser.pojo2json(MessageFactory.privateMessage(this.userId, userId, payload)));
            this.out.flush();
        }
    }

    @Override
    public void setMessageHandler(MessageHandler handler) {
        Objects.requireNonNull(handler);
        while (!this.backlog.isEmpty()) {
            this.process((MessageImpl)this.backlog.poll());
        }
    }

    @Override
    public String getUserId() {
        return this.userId;
    }
}

