/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.api.cactify;

import org.apache.cactus.integration.api.cactify.Redirector;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlUtils;
import org.codehaus.cargo.util.log.Logger;

public class ServletRedirector
extends Redirector {
    private static final String SERVLET_REDIRECTOR_CLASS = "org.apache.cactus.server.ServletTestRedirector";
    private static final String DEFAULT_SERVLET_REDIRECTOR_MAPPING = "/ServletRedirector";

    public ServletRedirector() {
        this.name = "ServletRedirector";
        this.mapping = DEFAULT_SERVLET_REDIRECTOR_MAPPING;
    }

    public ServletRedirector(Logger logger) {
        this();
        this.logger = logger;
    }

    public void mergeInto(WebXml theWebXml) {
        if (WebXmlUtils.getServletNamesForClass((WebXml)theWebXml, (String)SERVLET_REDIRECTOR_CLASS).hasNext() && this.logger != null) {
            this.logger.warn("WARNING: Your web.xml already includes " + this.name + " mapping. Cactus is adding another one " + "which may prevent your container from starting.", "WARNING");
        }
        WebXmlUtils.addServlet((WebXml)theWebXml, (String)this.name, (String)SERVLET_REDIRECTOR_CLASS);
        WebXmlUtils.addServletMapping((WebXml)theWebXml, (String)this.name, (String)this.mapping);
        if (this.roles != null) {
            this.addSecurity(theWebXml);
        }
    }
}

