/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.container;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.cactus.container.ContainerWrapper;
import org.apache.cactus.integration.api.exceptions.CactusRuntimeException;
import org.codehaus.cargo.util.log.Logger;

public final class ContainerRunner {
    private ContainerWrapper containerWrapper = null;
    private URL testURL;
    private long timeout = 180000L;
    private long checkInterval = 500L;
    private long shutDownWait = 2000L;
    private boolean alreadyRunning;
    private String serverName;
    private transient Logger logger;

    public ContainerRunner(ContainerWrapper theContainerWrapper) {
        this.containerWrapper = theContainerWrapper;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void startUpContainer() throws IllegalStateException {
        if (this.testURL == null) {
            throw new IllegalStateException("Property [url] must be set");
        }
        this.alreadyRunning = this.isAvailable(this.testConnectivity(this.testURL));
        if (this.alreadyRunning) {
            this.logger.debug("Server is already running", this.getClass().toString());
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ContainerRunner.this.containerWrapper.startUp();
            }
        });
        thread.start();
        long startTime = System.currentTimeMillis();
        int responseCode = -1;
        do {
            if (System.currentTimeMillis() - startTime > this.timeout) {
                throw new CactusRuntimeException("Failed to start the container after more than [" + this.timeout + "] ms. Trying to connect " + "to the [" + this.testURL + "] test URL yielded a [" + responseCode + "] error code. Please run in debug mode " + "for more details about the error.");
            }
            this.sleep(this.checkInterval);
            this.logger.debug("Checking if server is up ...", this.getClass().toString());
        } while (!this.isAvailable(responseCode = this.testConnectivity(this.testURL)));
        this.sleep(this.containerWrapper.getStartUpWait());
        this.serverName = this.retrieveServerName(this.testURL);
        this.logger.info("Server [" + this.serverName + "] started", this.getClass().toString());
    }

    public void shutDownContainer() throws IllegalStateException {
        if (this.testURL == null) {
            throw new IllegalStateException("Property [url] must be set");
        }
        if (this.alreadyRunning) {
            return;
        }
        if (!this.isAvailable(this.testConnectivity(this.testURL))) {
            this.logger.debug("Server isn't running!", this.getClass().toString());
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ContainerRunner.this.containerWrapper.shutDown();
            }
        });
        thread.start();
        do {
            this.sleep(this.checkInterval);
        } while (this.isAvailable(this.testConnectivity(this.testURL)));
        this.sleep(this.shutDownWait);
        this.logger.debug("Server stopped!", this.getClass().toString());
    }

    public void setCheckInterval(long theCheckInterval) {
        this.checkInterval = theCheckInterval;
    }

    public void setLogger(Logger theLogger) {
        this.logger = theLogger;
    }

    public void setShutDownWait(long theShutDownWait) {
        this.shutDownWait = theShutDownWait;
    }

    public void setTimeout(long theTimeout) {
        this.timeout = theTimeout;
    }

    public void setURL(URL theTestURL) {
        if (!theTestURL.getProtocol().equalsIgnoreCase("http") && !theTestURL.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("Not a HTTP or HTTPS URL");
        }
        this.testURL = theTestURL;
    }

    public int testConnectivity(URL theUrl) {
        int code;
        try {
            HttpURLConnection connection = (HttpURLConnection)theUrl.openConnection();
            connection.setRequestProperty("Connection", "close");
            connection.connect();
            ContainerRunner.readFully(connection);
            connection.disconnect();
            code = connection.getResponseCode();
        }
        catch (IOException e) {
            this.logger.debug("Failed to connect to [" + theUrl + "]", e.getMessage());
            code = -1;
        }
        return code;
    }

    private boolean isAvailable(int theCode) {
        boolean result = theCode != -1 && theCode < 300;
        return result;
    }

    private String retrieveServerName(URL theUrl) {
        String retVal = null;
        try {
            HttpURLConnection connection = (HttpURLConnection)theUrl.openConnection();
            connection.connect();
            retVal = connection.getHeaderField("Server");
            connection.disconnect();
        }
        catch (IOException e) {
            this.logger.debug("Could not get server name from [" + theUrl + "]", e.getMessage());
        }
        return retVal;
    }

    static void readFully(HttpURLConnection theConnection) throws IOException {
        if (theConnection.getContentLength() != 0) {
            byte[] buf = new byte[256];
            InputStream in = theConnection.getInputStream();
            while (in.read(buf) != -1) {
            }
        }
    }

    private void sleep(long theMs) throws CactusRuntimeException {
        try {
            Thread.sleep(theMs);
        }
        catch (InterruptedException e) {
            throw new CactusRuntimeException("Interruption during sleep", e);
        }
    }
}

