(ns burningswell.api.server
  (:require [burningswell.api.interceptors :refer [add-interceptors]]
            [burningswell.api.routes :refer [routes]]
            [burningswell.pedestal.server :refer [server]]
            [com.stuartsierra.component :as component]))

(defn new-api
  "Return a new API server."
  [& [config]]
  (-> (assoc config :routes #(deref #'routes) :init add-interceptors)
      (server)
      (component/using [:api-client :broker :config :db :topology])))
