(ns burningswell.api.geocode
  (:require [burningswell.geoip.core :as geoip]
            [burningswell.http.response :refer [not-found ok]]))

(defn internet-address
  "Geocode the internet address of the current request."
  [{:keys [geoip remote-addr path-params]}]
  (let [address (or (:internet-address path-params) remote-addr)]
    (if-let [result (geoip/geocode geoip address)]
      (ok result)
      (not-found
       {:error "Can't geocode internet address."
        :internet-address address}))))
