(ns burningswell.api.config
  (:require [burningswell.http.response :refer [ok]]))

(set! *warn-on-reflection* true)

(defn facebook
  "Return the Facebook configuration."
  [{:keys [facebook]} user]
  (select-keys facebook [:client-id :redirect-uri]))

(defn flickr
  "Return the Flickr configuration."
  [{:keys [flickr]} user]
  (select-keys flickr [:api-key]))

(defn google
  "Return the Google configuration."
  [{:keys [google]} user]
  {:maps (select-keys (:maps google) [:api-key])})

(defn config
  "Return the configuration."
  [{:keys [config]}]
  (ok {:api (:api-client config)
       :facebook (facebook config identity)
       :flickr (flickr config identity)
       :google (google config identity)
       :web (:web config)}))

(set! *warn-on-reflection* false)
