/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.text;

import aljx.java.util.debug.Tracer;
import aljx.java.util.stream.StreamReader;
import aljx.java.util.stream.StringInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TextUtils {
    public static String ellipsize(String s, int maxLength) {
        return s != null && s.length() > maxLength ? s.substring(0, maxLength) + "..." : s;
    }

    public static String join(CharSequence delimiter, Iterable tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    private String removeFromEnd(String source, String endStr) {
        int lastIndexOf;
        StringBuilder sb = new StringBuilder(source);
        while ((lastIndexOf = sb.lastIndexOf(endStr)) > -1 && lastIndexOf + endStr.length() == sb.length()) {
            sb.setLength(lastIndexOf);
        }
        return sb.toString();
    }

    public static String makeNotNull(String s) {
        return s != null ? s : "";
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNotEmpty(String s) {
        return !TextUtils.isEmpty(s);
    }

    public static boolean isAllEmpty(String ... strArr) {
        for (String s : strArr) {
            if (TextUtils.isEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotEmpty(String ... strArr) {
        for (String s : strArr) {
            if (!TextUtils.isEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static int getAfterSpaceIndex(String line, int startIndex) {
        int spaceIndex = line.indexOf(32, startIndex);
        if (spaceIndex >= 0) {
            try {
                int afterSpaceIndex = spaceIndex + 1;
                while (line.charAt(afterSpaceIndex) == ' ') {
                    ++afterSpaceIndex;
                }
                return afterSpaceIndex;
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    public static ArrayList<String> wordWrap(String line, int lineLength) {
        if (TextUtils.isEmpty(line)) {
            throw new IllegalArgumentException("Empty line unsupported");
        }
        if (line.contains("\n")) {
            throw new IllegalArgumentException("Line with next line chars unsupported");
        }
        ArrayList<String> lines = new ArrayList<String>();
        int startIndex = 0;
        while (true) {
            int afterSpaceIndexNext;
            int afterSpaceIndex;
            if ((afterSpaceIndex = TextUtils.getAfterSpaceIndex(line, startIndex)) == -1) break;
            if (afterSpaceIndex - startIndex >= lineLength) {
                lines.add(line.substring(startIndex, afterSpaceIndex));
                startIndex = afterSpaceIndex;
                continue;
            }
            while ((afterSpaceIndexNext = TextUtils.getAfterSpaceIndex(line, afterSpaceIndex)) - startIndex < lineLength && afterSpaceIndexNext != -1) {
                afterSpaceIndex = afterSpaceIndexNext;
            }
            lines.add(line.substring(startIndex, afterSpaceIndex));
            startIndex = afterSpaceIndex;
        }
        lines.add(line.substring(startIndex));
        return lines;
    }

    public static List<String> splitLines(String string) {
        List<String> origTextLines = null;
        try {
            origTextLines = StreamReader.streamToStringList(new StringInputStream(string));
        }
        catch (IOException e) {
            Tracer.e(e);
        }
        return origTextLines;
    }

    public static String concat(List<String> text, boolean newLine) {
        StringBuilder sb = new StringBuilder();
        for (String string : text) {
            sb.append(string);
            if (!newLine) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String humanReadableByteCount(long bytes) {
        return TextUtils.humanReadableByteCount(bytes, false);
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "" + (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

