/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.image;

public class ARGBPixelHelper {
    public static boolean isTransparent(int pixel) {
        return ARGBPixelHelper.getAlpha(pixel) == 0;
    }

    public static boolean isTranslucent(int pixel) {
        return ARGBPixelHelper.getAlpha(pixel) > 0;
    }

    public static boolean isFullOpacity(int pixel) {
        return ARGBPixelHelper.getAlpha(pixel) == 255;
    }

    public static String getPixelInfo(int pixel, int x, int y) {
        int alpha = ARGBPixelHelper.getAlpha(pixel);
        int red = ARGBPixelHelper.getRed(pixel);
        int green = ARGBPixelHelper.getGreen(pixel);
        int blue = ARGBPixelHelper.getBlue(pixel);
        return String.format("(%d,%d) argb: %d, %d, %d, %d", x, y, alpha, red, green, blue);
    }

    private static int getBlue(int pixel) {
        return pixel & 0xFF;
    }

    private static int getGreen(int pixel) {
        return pixel >> 8 & 0xFF;
    }

    private static int getRed(int pixel) {
        return pixel >> 16 & 0xFF;
    }

    private static int getAlpha(int pixel) {
        return pixel >> 24 & 0xFF;
    }
}

