/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.file;

import aljx.java.util.debug.Tracer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;

public class LogSaveHelper {
    public static final int ONE_K = 1024;
    public static final int TEN_K = 10240;
    public static final long ONE_MB = 0x100000L;
    private static final long EIGHT_MB = 0x800000L;
    private static final AtomicReference<Long> sMaxLogFileSize = new AtomicReference<Long>(0x800000L);
    private static FileOutputStream mLogFileStream;
    private static File logFile;
    private static final AtomicReference<String> sLogFileName;
    private static final AtomicReference<String> sOldLogFileName;
    private static final AtomicReference<File> sLogFileDir;

    public static void setSettings(File logFileDir, String logFileName, String oldLogFileName, long maxFileSize) {
        sMaxLogFileSize.set(maxFileSize);
        sLogFileName.set(logFileName);
        sOldLogFileName.set(oldLogFileName);
        sLogFileDir.set(logFileDir);
    }

    public static boolean write(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        FileOutputStream logFileStream = LogSaveHelper.getLogFileStream(false);
        if (logFileStream != null) {
            logFileStream.write(buffer, byteOffset, byteCount);
            logFileStream.flush();
        }
        return true;
    }

    public static void write(String s) throws IOException {
        byte[] bytes = s.getBytes(Charset.forName("UTF-8"));
        LogSaveHelper.write(bytes, 0, bytes.length);
    }

    public static FileOutputStream getLogFileStream(boolean prepare) {
        if (prepare || logFile != null && logFile.length() > sMaxLogFileSize.get()) {
            LogSaveHelper.closeLogFileStream();
            LogSaveHelper.prepareLogFile();
            LogSaveHelper.initLogWriter();
        }
        if (mLogFileStream == null || logFile == null) {
            LogSaveHelper.initLogWriter();
        }
        return mLogFileStream;
    }

    public static void closeLogFileStream() {
        if (mLogFileStream != null) {
            try {
                mLogFileStream.close();
                mLogFileStream = null;
                logFile = null;
            }
            catch (IOException e) {
                mLogFileStream = null;
                logFile = null;
                Tracer.e("error closing output stream", e);
            }
        }
    }

    private static File prepareLogFile() {
        File f = null;
        try {
            f = new File(sLogFileDir.get(), sLogFileName.get());
            if (f.exists()) {
                File from = new File(sLogFileDir.get(), sLogFileName.get());
                File to = new File(sLogFileDir.get(), sOldLogFileName.get());
                if (to.exists()) {
                    to.delete();
                }
                from.renameTo(to);
            }
            f = new File(sLogFileDir.get(), sLogFileName.get());
            f.createNewFile();
        }
        catch (IOException e) {
            Tracer.e(e);
        }
        return f;
    }

    private static File getLogFile() {
        File f = null;
        try {
            f = new File(sLogFileDir.get(), sLogFileName.get());
            if (!f.exists()) {
                f.createNewFile();
            }
        }
        catch (IOException e) {
            Tracer.e(e);
        }
        return f;
    }

    private static void initLogWriter() {
        try {
            logFile = LogSaveHelper.getLogFile();
            mLogFileStream = new FileOutputStream(logFile, true);
        }
        catch (IOException e) {
            Tracer.e(e);
        }
    }

    static {
        sLogFileName = new AtomicReference();
        sOldLogFileName = new AtomicReference();
        sLogFileDir = new AtomicReference();
    }
}

