/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.debug;

import aljx.java.util.debug.Logger;
import aljx.java.util.state.ConcurrentCache;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class Tracer {
    private static AtomicBoolean isPrintToLog = new AtomicBoolean(true);
    public static final String TRACER = "Tracer";
    private static final int CLIENT_CODE_STACK_INDEX;
    private static final ConcurrentCache sConcurrentCache;
    private static final AtomicReference<Logger.LogImplementation> logger;

    public static void setLogger(Logger.LogImplementation loggerImpl) {
        logger.set(loggerImpl);
    }

    public static String getSteInfo(int depth, int depthOffset) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String result = null;
        if (depth == 1) {
            result = stackTrace[CLIENT_CODE_STACK_INDEX + depthOffset].toString();
        } else if (depth > 1) {
            int lastNeedfulIndex = CLIENT_CODE_STACK_INDEX + depthOffset + depth;
            int nextLine = 10;
            StringBuilder sb = new StringBuilder();
            for (int i = CLIENT_CODE_STACK_INDEX + depthOffset; i < stackTrace.length && i < lastNeedfulIndex; ++i) {
                sb.append(stackTrace[i]).append('\n');
            }
            result = sb.toString();
        }
        return result;
    }

    public static String getFileName(int depthOffset) {
        StackTraceElement element = Thread.currentThread().getStackTrace()[CLIENT_CODE_STACK_INDEX + depthOffset];
        String result = element.getFileName();
        int position = result.indexOf(".java");
        return position > -1 ? result.substring(0, position) : result;
    }

    public static String getMethodName(int depthOffset) {
        StackTraceElement element = Thread.currentThread().getStackTrace()[CLIENT_CODE_STACK_INDEX + depthOffset];
        return element.getMethodName();
    }

    public static void setEnable(boolean isPrintToLog) {
        Tracer.isPrintToLog.set(isPrintToLog);
    }

    public static boolean isPrintToLog() {
        return isPrintToLog.get();
    }

    public static void v(String message) {
        logger.get().v(TRACER, Tracer.getFileName(0) + " " + message);
    }

    public static void d(String message) {
        logger.get().d(TRACER, Tracer.getFileName(0) + " " + message);
    }

    public static void i(String message) {
        logger.get().i(TRACER, Tracer.getFileName(0) + " " + message);
    }

    public static void w(String message) {
        logger.get().w(TRACER, Tracer.getFileName(0) + " " + message);
    }

    public static void w(String message, Throwable tr) {
        logger.get().w(TRACER, Tracer.getFileName(0) + " " + message, tr);
    }

    public static void e(String message) {
        logger.get().e(TRACER, Tracer.getFileName(0) + " " + message);
    }

    public static void e(Throwable tr) {
        logger.get().e(TRACER, Tracer.getFileName(0) + " " + "Failed", tr);
    }

    public static void e(String message, Throwable tr) {
        logger.get().e(TRACER, Tracer.getFileName(0) + " " + message, tr);
    }

    public static void log(String message, int depthOffset) {
        if (!isPrintToLog.get()) {
            return;
        }
        logger.get().i(TRACER, message != null ? Tracer.getFileName(depthOffset) + " " + message : "null");
    }

    public static void print() {
        if (!isPrintToLog.get()) {
            return;
        }
        int depth = 1;
        String steInfo = Tracer.getSteInfo(depth, 0);
        Tracer.print(depth, steInfo, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printChanges(Object key, Object additionalMsg) {
        if (!isPrintToLog.get()) {
            return;
        }
        ConcurrentCache concurrentCache = sConcurrentCache;
        synchronized (concurrentCache) {
            if (sConcurrentCache.compare(key, additionalMsg)) {
                return;
            }
            sConcurrentCache.put(key, additionalMsg);
        }
        int depth = 1;
        String steInfo = Tracer.getSteInfo(depth, 0);
        Tracer.print(depth, steInfo, false, additionalMsg);
    }

    public static void print(Object additionalMsg) {
        if (!isPrintToLog.get()) {
            return;
        }
        int depth = 1;
        String steInfo = Tracer.getSteInfo(depth, 0);
        Tracer.print(depth, steInfo, false, additionalMsg);
    }

    public static void print(int depth) {
        if (!isPrintToLog.get()) {
            return;
        }
        String steInfo = Tracer.getSteInfo(depth, 0);
        Tracer.print(depth, steInfo, false, null);
    }

    public static void print(int depth, Object additionalMsg) {
        if (!isPrintToLog.get()) {
            return;
        }
        String steInfo = Tracer.getSteInfo(depth, 0);
        Tracer.print(depth, steInfo, false, additionalMsg);
    }

    public static void printWithDepthOffset(int depthOffset, Object additionalMsg) {
        if (!isPrintToLog.get()) {
            return;
        }
        int depth = 1;
        String steInfo = Tracer.getSteInfo(depth, depthOffset);
        Tracer.print(depth, steInfo, false, additionalMsg);
    }

    public static void printInfo() {
        if (!isPrintToLog.get()) {
            return;
        }
        int depth = 1;
        String steInfo = Tracer.getSteInfo(depth, 0);
        Tracer.print(depth, steInfo, true, null);
    }

    public static void printInfo(Object additionalMsg) {
        if (!isPrintToLog.get()) {
            return;
        }
        int depth = 1;
        String steInfo = Tracer.getSteInfo(depth, 0);
        Tracer.print(depth, steInfo, true, additionalMsg);
    }

    public static void printInfo(int depth) {
        if (!isPrintToLog.get()) {
            return;
        }
        String steInfo = Tracer.getSteInfo(depth, 0);
        Tracer.print(depth, steInfo, true, null);
    }

    public static void printInfo(int depth, Object additionalMsg) {
        if (!isPrintToLog.get()) {
            return;
        }
        String steInfo = Tracer.getSteInfo(depth, 0);
        Tracer.print(depth, steInfo, true, additionalMsg);
    }

    public static void print(int depth, String steInfo, boolean printThreadInfo, Object msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(steInfo);
        if (printThreadInfo) {
            Thread currentThread = Thread.currentThread();
            sb.append(" tid = ").append(currentThread.getId()).append(" tname = ");
            sb.append(currentThread.getName());
        }
        if (msg != null) {
            sb.append(" ").append(msg.toString());
        }
        logger.get().i(TRACER, sb.toString());
    }

    static {
        sConcurrentCache = new ConcurrentCache();
        logger = new AtomicReference<Logger.LogImplementation>(Logger.logger);
        int i = 0;
        try {
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                ++i;
                if (!ste.getClassName().equals(Tracer.class.getName())) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CLIENT_CODE_STACK_INDEX = ++i;
    }
}

