/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.debug;

public class TraceHelper {
    private static final int CLIENT_CODE_STACK_INDEX;

    public static String getSteInfo(int depth, int depthOffset) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String result = null;
        if (depth == 1) {
            result = stackTrace[CLIENT_CODE_STACK_INDEX + depthOffset].toString();
        } else if (depth > 1) {
            int lastNeedfulIndex = CLIENT_CODE_STACK_INDEX + depthOffset + depth;
            int nextLine = 10;
            StringBuilder sb = new StringBuilder();
            for (int i = CLIENT_CODE_STACK_INDEX + depthOffset; i < stackTrace.length && i < lastNeedfulIndex; ++i) {
                sb.append(stackTrace[i]).append('\n');
            }
            result = sb.toString();
        }
        return result;
    }

    public static String getFileName(int depthOffset) {
        StackTraceElement element = Thread.currentThread().getStackTrace()[CLIENT_CODE_STACK_INDEX + depthOffset];
        String result = element.getFileName();
        int position = result.indexOf(".java");
        return position > -1 ? result.substring(0, position) : result;
    }

    public static String getMethodName(int depthOffset) {
        StackTraceElement element = Thread.currentThread().getStackTrace()[CLIENT_CODE_STACK_INDEX + depthOffset];
        return element.getMethodName();
    }

    public static String callInfoShort() {
        int depth = 1;
        StackTraceElement element = Thread.currentThread().getStackTrace()[CLIENT_CODE_STACK_INDEX + depth];
        String result = element.getFileName();
        int position = result.indexOf(".java");
        String fileName = position > -1 ? result.substring(0, position) : result;
        result = element.getMethodName();
        position = result.lastIndexOf(46);
        String methodName = position > -1 && position + 1 < result.length() ? result.substring(position + 1) : result;
        return String.format("%s(%s:%d)", methodName, fileName, element.getLineNumber());
    }

    public static String callInfo() {
        return TraceHelper.getSteInfo(1, 0);
    }

    public static String callInfoFull() {
        Thread currentThread = Thread.currentThread();
        StringBuilder sb = new StringBuilder();
        sb.append(" tid = ").append(currentThread.getId()).append(" tname = ");
        sb.append(currentThread.getName());
        sb.append(" ").append(TraceHelper.getSteInfo(1, 0));
        return sb.toString();
    }

    static {
        int i = 0;
        try {
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                ++i;
                if (!ste.getClassName().equals(TraceHelper.class.getName())) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CLIENT_CODE_STACK_INDEX = ++i;
    }
}

