/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.debug;

import aljx.java.util.debug.Dumper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;

public class DefaultDumpExtension
extends Dumper.DumpExtension {
    @Override
    public String dumpImpl(Object value, ArrayList dumpedObjects) {
        if (!this.canDump(value)) {
            throw new IllegalArgumentException(value.getClass().getName() + " unsupported for dump");
        }
        if (value instanceof byte[]) {
            return DefaultDumpExtension.dumpImpl((byte[])value, dumpedObjects);
        }
        if (value instanceof short[]) {
            return DefaultDumpExtension.dumpImpl((short[])value, dumpedObjects);
        }
        if (value instanceof int[]) {
            return DefaultDumpExtension.dumpImpl((int[])value, dumpedObjects);
        }
        if (value instanceof long[]) {
            return DefaultDumpExtension.dumpImpl((long[])value, dumpedObjects);
        }
        if (value instanceof float[]) {
            return DefaultDumpExtension.dumpImpl((float[])value, dumpedObjects);
        }
        if (value instanceof double[]) {
            return DefaultDumpExtension.dumpImpl((double[])value, dumpedObjects);
        }
        if (value instanceof char[]) {
            return DefaultDumpExtension.dumpImpl((char[])value, dumpedObjects);
        }
        if (value instanceof boolean[]) {
            return DefaultDumpExtension.dumpImpl((boolean[])value, dumpedObjects);
        }
        if (value instanceof Object[]) {
            return this.dumpImpl((Object[])value, dumpedObjects);
        }
        if (value instanceof Properties) {
            return this.dumpImpl((Properties)value, dumpedObjects);
        }
        if (value instanceof Collection) {
            return this.dumpImpl((Collection)value, dumpedObjects);
        }
        if (value instanceof Map) {
            return this.dumpImpl((Map)value, dumpedObjects);
        }
        if (value instanceof Map.Entry) {
            return this.dumpImpl((Map.Entry)value, dumpedObjects);
        }
        if (value instanceof Iterator) {
            return this.dumpImpl((Iterator)value, dumpedObjects);
        }
        if (value instanceof Throwable) {
            return this.dumpImpl((Throwable)value, dumpedObjects);
        }
        if (value instanceof URI) {
            return DefaultDumpExtension.dumpImpl((URI)value, dumpedObjects);
        }
        if (value instanceof ZipEntry) {
            return this.dumpImpl((ZipEntry)value, dumpedObjects);
        }
        if (value instanceof Thread) {
            return this.dumpImpl((Thread)value, dumpedObjects);
        }
        if (value instanceof ThreadGroup) {
            return this.dumpImpl((ThreadGroup)value, dumpedObjects);
        }
        throw new IllegalStateException("Failed dump " + value.getClass().getName());
    }

    @Override
    public boolean canDump(Object value) {
        if (value instanceof byte[]) {
            return true;
        }
        if (value instanceof short[]) {
            return true;
        }
        if (value instanceof int[]) {
            return true;
        }
        if (value instanceof long[]) {
            return true;
        }
        if (value instanceof float[]) {
            return true;
        }
        if (value instanceof double[]) {
            return true;
        }
        if (value instanceof char[]) {
            return true;
        }
        if (value instanceof boolean[]) {
            return true;
        }
        if (value instanceof Object[]) {
            return true;
        }
        if (value instanceof Properties) {
            return true;
        }
        if (value instanceof Collection) {
            return true;
        }
        if (value instanceof Map) {
            return true;
        }
        if (value instanceof Map.Entry) {
            return true;
        }
        if (value instanceof Iterator) {
            return true;
        }
        if (value instanceof Throwable) {
            return true;
        }
        if (value instanceof URI) {
            return true;
        }
        if (value instanceof ZipEntry) {
            return true;
        }
        if (value instanceof Thread) {
            return true;
        }
        return value instanceof ThreadGroup;
    }

    private static String dumpImpl(byte[] array, ArrayList dumpedObjects) {
        return Arrays.toString(array);
    }

    private static String dumpImpl(short[] array, ArrayList dumpedObjects) {
        return Arrays.toString(array);
    }

    private static String dumpImpl(int[] array, ArrayList dumpedObjects) {
        return Arrays.toString(array);
    }

    private static String dumpImpl(long[] array, ArrayList dumpedObjects) {
        return Arrays.toString(array);
    }

    private static String dumpImpl(float[] array, ArrayList dumpedObjects) {
        return Arrays.toString(array);
    }

    private static String dumpImpl(double[] array, ArrayList dumpedObjects) {
        return Arrays.toString(array);
    }

    private static String dumpImpl(char[] array, ArrayList dumpedObjects) {
        return Arrays.toString(array);
    }

    private static String dumpImpl(boolean[] array, ArrayList dumpedObjects) {
        return Arrays.toString(array);
    }

    private String dumpImpl(Object[] array, ArrayList dumpedObjects) {
        return this.dump(Arrays.asList(array), dumpedObjects);
    }

    private String dumpImpl(Collection<?> collection, ArrayList dumpedObjects) {
        return this.dump(collection.iterator(), dumpedObjects);
    }

    private String dumpImpl(Map<?, ?> map, ArrayList dumpedObjects) {
        return map.getClass().getSimpleName() + " " + this.dump(map.entrySet().iterator(), dumpedObjects);
    }

    private String dumpImpl(Map.Entry<?, ?> entry, ArrayList dumpedObjects) {
        return this.dump(entry.getKey(), dumpedObjects) + "=" + this.dump(entry.getValue(), dumpedObjects);
    }

    private String dumpImpl(Iterator iterator, ArrayList dumpedObjects) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (iterator.hasNext()) {
            sb.append(this.dump(iterator.next(), dumpedObjects));
            while (iterator.hasNext()) {
                sb.append(", ").append(this.dump(iterator.next(), dumpedObjects));
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private String dumpImpl(Throwable ex, ArrayList dumpedObjects) {
        StringBuilder sb = new StringBuilder();
        String info = null;
        try {
            info = ex.toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        sb.append(info).append('\n');
        StackTraceElement[] stackTrace = null;
        try {
            stackTrace = ex.getStackTrace();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (stackTrace == null) {
            sb.append("null").append('\n');
        } else {
            for (StackTraceElement stackTraceElement : stackTrace) {
                sb.append(stackTraceElement.toString()).append('\n');
            }
        }
        Throwable cause = null;
        try {
            cause = ex.getCause();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cause != null && cause != ex) {
            sb.append("Caused by: ").append('\n').append(this.dump(cause, dumpedObjects));
        }
        return sb.toString();
    }

    private static String dumpImpl(URI uri, ArrayList dumpedObjects) {
        String authority = uri.getAuthority();
        String fragment = uri.getFragment();
        String host = uri.getHost();
        String path = uri.getPath();
        int port = uri.getPort();
        String query = uri.getQuery();
        String encodedAuthority = uri.getRawAuthority();
        String encodedFragment = uri.getRawFragment();
        String encodedPath = uri.getRawPath();
        String encodedQuery = uri.getRawQuery();
        String encodedSchemeSpecificPart = uri.getRawSchemeSpecificPart();
        String encodedUserInfo = uri.getRawUserInfo();
        String scheme = uri.getScheme();
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        String userInfo = uri.getUserInfo();
        String toASCIIString = uri.toASCIIString();
        String normalize = uri.normalize().toString();
        String normalizeScheme = null;
        String lastPathSegment = null;
        Object pathSegments = null;
        boolean isAbsolute = uri.isAbsolute();
        boolean isOpaque = uri.isOpaque();
        Object isHierarchical = null;
        Object isRelative = null;
        Object queryParameterNames = null;
        StringBuilder sb = new StringBuilder();
        sb.append(uri);
        sb.append("\n");
        sb.append(" authority = ").append(authority);
        sb.append("\n");
        sb.append(" encodedAuthority = ").append(encodedAuthority);
        sb.append("\n");
        sb.append(" encodedFragment = ").append(encodedFragment);
        sb.append("\n");
        sb.append(" encodedPath = ").append(encodedPath);
        sb.append("\n");
        sb.append(" encodedQuery = ").append(encodedQuery);
        sb.append("\n");
        sb.append(" encodedSchemeSpecificPart = ").append(encodedSchemeSpecificPart);
        sb.append("\n");
        sb.append(" encodedUserInfo = ").append(encodedUserInfo);
        sb.append("\n");
        sb.append(" fragment = ").append(fragment);
        sb.append("\n");
        sb.append(" host = ").append(host);
        sb.append("\n");
        sb.append(" lastPathSegment = ").append(lastPathSegment);
        sb.append("\n");
        sb.append(" path = ").append(path);
        sb.append("\n");
        sb.append(" pathSegments = ").append((Object)pathSegments);
        sb.append("\n");
        sb.append(" port = ").append(port);
        sb.append("\n");
        sb.append(" query = ").append(query);
        sb.append("\n");
        sb.append(" queryParameterNames = ").append((Object)queryParameterNames);
        sb.append("\n");
        sb.append(" scheme = ").append(scheme);
        sb.append("\n");
        sb.append(" schemeSpecificPart = ").append(schemeSpecificPart);
        sb.append("\n");
        sb.append(" userInfo = ").append(userInfo);
        sb.append("\n");
        sb.append(" toASCIIString = ").append(toASCIIString);
        sb.append("\n");
        sb.append(" normalize = ").append(normalize);
        sb.append("\n");
        sb.append(" normalizeScheme = ").append(normalizeScheme);
        sb.append("\n");
        sb.append(" isAbsolute = ").append(isAbsolute);
        sb.append("\n");
        sb.append(" isOpaque = ").append(isOpaque);
        sb.append("\n");
        sb.append(" isHierarchical = ").append((Object)isHierarchical);
        sb.append("\n");
        sb.append(" isRelative = ").append((Object)isRelative);
        sb.append("\n");
        return sb.toString();
    }

    private String dumpImpl(ZipEntry zipEntry, ArrayList dumpedObjects) {
        StringBuilder sb = new StringBuilder();
        sb.append("ZipEntry [");
        sb.append("\n").append("class = " + zipEntry.getClass());
        sb.append("\n").append("name = " + zipEntry.getName());
        sb.append("\n").append("isDirectory = " + zipEntry.isDirectory());
        sb.append("\n").append("comment = " + zipEntry.getComment());
        sb.append("\n").append("compressedSize = " + zipEntry.getCompressedSize());
        sb.append("\n").append("crc = " + zipEntry.getCrc());
        sb.append("\n").append("extra = " + zipEntry.getExtra());
        sb.append("\n").append("method = " + zipEntry.getMethod());
        sb.append("\n").append("size = " + zipEntry.getSize());
        sb.append("\n").append("time = " + zipEntry.getTime());
        sb.append("\n").append("]");
        return sb.toString();
    }

    private String dumpImpl(Properties properties, ArrayList dumpedObjects) {
        Set<String> keys = properties.stringPropertyNames();
        HashMap<String, String> hm = new HashMap<String, String>();
        for (String key : keys) {
            hm.put(key, properties.getProperty(key));
        }
        return String.format("Properties [%s]", this.dump(hm, dumpedObjects));
    }

    private String dumpImpl(Thread object, ArrayList dumpedObjects) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName() + "[" + "@" + Integer.toHexString(object.hashCode()) + ", id=" + object.getId() + ", name=" + object.getName() + ", getPriority = " + object.getPriority() + ", getState = " + (Object)((Object)object.getState()) + ", isDaemon = " + object.isDaemon() + ", isAlive = " + object.isAlive() + ", isInterrupted = " + object.isInterrupted() + ", getThreadGroup = " + this.dump(object.getThreadGroup(), dumpedObjects) + "]" + object.getId();
    }

    private String dumpImpl(ThreadGroup object, ArrayList dumpedObjects) {
        return object.getClass().getName() + "[" + "@" + Integer.toHexString(object.hashCode()) + ", name=" + object.getName() + ", maxPriority=" + object.getMaxPriority() + ", isDaemon = " + object.isDaemon() + "]";
    }
}

