/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.filter;

import aljx.java.util.file.zip.filter.ZipEntryFilter;
import aljx.java.util.filter.Filter;
import aljx.java.util.text.filter.StringFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;

class FilterWrapper {
    FilterWrapper() {
    }

    public static <FilterType, CheckingArgType> Filter<CheckingArgType> wrap(final FilterType filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter = " + filter);
        }
        return new Filter<CheckingArgType>(){

            @Override
            public boolean accept(CheckingArgType checkingArgType) {
                if (filter instanceof StringFilter) {
                    return ((StringFilter)filter).accept((String)checkingArgType);
                }
                if (filter instanceof FileFilter) {
                    return ((FileFilter)filter).accept((File)checkingArgType);
                }
                if (filter instanceof ZipEntryFilter) {
                    return ((ZipEntryFilter)filter).accept((ZipEntry)checkingArgType);
                }
                throw new IllegalArgumentException("Unknown filter = " + filter);
            }
        };
    }

    public static <FilterType> List<Filter> wrap(FilterType ... filterArr) {
        return FilterWrapper.wrap(Arrays.asList(filterArr));
    }

    public static <FilterType> List<Filter> wrap(List<FilterType> stringFilterList) {
        ArrayList<Filter> list = new ArrayList<Filter>();
        for (FilterType item : stringFilterList) {
            list.add(FilterWrapper.wrap(item));
        }
        return list;
    }
}

